/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.ansi.sgr;

import de.linusdev.lutils.ansi.sgr.SGRParameter;
import de.linusdev.lutils.ansi.sgr.SGRParameters;
import org.jetbrains.annotations.NotNull;

public class SGR {
    public static final String SGR_START_CODE = "\u001b[";
    public static final String SGR_PARAMETER_DELIMITER = ";";
    public static final String SGR_END_CODE = "m";
    @NotNull
    public static final String RESET_CONSTRUCTED = new SGR(SGRParameters.RESET, new String[0]).construct();
    @NotNull
    private final String delimiter;
    @NotNull
    private final StringBuilder sb;

    @NotNull
    public static String reset() {
        return RESET_CONSTRUCTED;
    }

    public SGR(@NotNull String delimiter) {
        this.delimiter = delimiter;
        this.sb = new StringBuilder(SGR_START_CODE);
    }

    public SGR() {
        this(SGR_PARAMETER_DELIMITER);
    }

    public SGR(@NotNull String delimiter, @NotNull SGRParameter sgrParam, String ... params) {
        this.delimiter = delimiter;
        this.sb = new StringBuilder(SGR_START_CODE);
        this.sb.append(sgrParam.construct(delimiter, params));
    }

    public SGR(@NotNull SGRParameter sgrParam, String ... params) {
        this(SGR_PARAMETER_DELIMITER, sgrParam, params);
    }

    public SGR add(@NotNull SGRParameter sgrParam, String ... params) {
        if (this.sb.length() > SGR_START_CODE.length()) {
            this.sb.append(this.delimiter);
        }
        this.sb.append(sgrParam.construct(this.delimiter, params));
        return this;
    }

    @NotNull
    public String construct() {
        return this.sb + SGR_END_CODE;
    }
}

