/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.http_WIP;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NotNull;

public class HTTPRequestReader {
    @NotNull
    private final CharsetDecoder decoder;
    @NotNull
    private final InputStream stream;
    private final ByteBuffer bufBytes;
    private final CharBuffer bufChars;
    private int nextByte = -2;

    public HTTPRequestReader(@NotNull CharsetDecoder decoder, @NotNull InputStream stream) {
        this.decoder = decoder;
        this.stream = stream;
        this.bufBytes = ByteBuffer.allocate(1024);
        this.bufChars = CharBuffer.allocate(1024);
        this.bufBytes.limit(0);
        this.bufChars.limit(0);
    }

    public HTTPRequestReader(@NotNull InputStream stream) {
        this(StandardCharsets.UTF_8.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE), stream);
    }

    public int readByte() throws IOException {
        if (this.bufBytes.remaining() == 0 && (this.nextByte == -1 || this.readBytesToBuffer() == 0)) {
            return -1;
        }
        return this.bufBytes.get();
    }

    private int readBytesToBuffer() throws IOException {
        if (this.nextByte != -1) {
            this.bufBytes.position(0);
            if (this.nextByte > 0) {
                this.bufBytes.put((byte)this.nextByte);
                this.bufBytes.limit(1);
            } else {
                this.bufBytes.limit(0);
            }
            int byteCount = this.stream.read(this.bufBytes.array());
            if (byteCount != -1) {
                this.nextByte = this.stream.read();
                this.bufBytes.limit(byteCount + this.bufBytes.limit());
            } else {
                this.nextByte = -1;
            }
            return this.bufBytes.remaining();
        }
        return 0;
    }

    public void decodeChars() {
        this.bufChars.position(0);
        this.bufChars.limit(this.bufChars.capacity());
        int oldPos = this.bufBytes.position();
        CoderResult result = this.decoder.decode(this.bufBytes, this.bufChars, this.nextByte == -1);
        int read = this.bufBytes.position() - oldPos;
        this.bufBytes.position(oldPos);
        this.bufChars.limit(read);
        if (result.isUnderflow()) {
            return;
        }
        if (result.isOverflow()) {
            throw new RuntimeException("yes");
        }
    }

    public int readChar() throws IOException {
        if (this.bufChars.remaining() == 0) {
            if (this.nextByte == -1 || this.readBytesToBuffer() == 0) {
                return -1;
            }
            this.decodeChars();
            if (this.bufChars.remaining() == 0) {
                return -1;
            }
        }
        this.bufBytes.position(this.bufBytes.position() + 1);
        return this.bufChars.get();
    }

    public String readLine() throws IOException {
        int r;
        StringBuilder str = new StringBuilder();
        boolean pcr = false;
        while ((r = this.readChar()) != -1) {
            char c = (char)r;
            if (pcr && c == '\n') {
                return str.toString();
            }
            if (pcr) {
                pcr = false;
                str.append('\r');
            }
            if (c == '\r') {
                pcr = true;
                continue;
            }
            str.append(c);
        }
        if (pcr) {
            str.append('\r');
        }
        return str.toString();
    }

    @NotNull
    public InputStream getInputStreamForRemaining() {
        final HTTPRequestReader this_ = this;
        return new InputStream(){

            @Override
            public int read() throws IOException {
                return this_.readByte();
            }
        };
    }
}

