/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.http_WIP;

import de.linusdev.lutils.http_WIP.HTTPRequestReader;
import de.linusdev.lutils.http_WIP.body.BodyParser;
import de.linusdev.lutils.http_WIP.header.Header;
import de.linusdev.lutils.http_WIP.method.RequestMethod;
import de.linusdev.lutils.http_WIP.version.HTTPVersion;
import de.linusdev.lutils.http_WIP.version.HTTPVersions;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HTTPRequest<B> {
    @NotNull
    private final RequestMethod method;
    @Nullable
    private final String path;
    @NotNull
    private final HTTPVersion version;
    @NotNull
    private final Map<String, Header> headers;
    @Nullable
    private final B body;

    public HTTPRequest(@NotNull RequestMethod method, @Nullable String path, @NotNull HTTPVersion version, @NotNull Map<String, Header> headers, @Nullable B body) {
        this.method = method;
        this.path = path;
        this.version = version;
        this.headers = headers;
        this.body = body;
    }

    @NotNull
    public static <B> HTTPRequest<B> parse(@NotNull InputStream in, @NotNull BodyParser<B> parser) throws IOException {
        String line;
        HTTPVersion version;
        HTTPRequestReader reader = new HTTPRequestReader(in);
        String first = reader.readLine();
        String[] parts = first.split(" ");
        if (parts.length <= 1) {
            throw new IllegalArgumentException("Malformed HTTP Request: first line: " + first);
        }
        RequestMethod method = RequestMethod.of(parts[0]);
        String path = null;
        HashMap<String, Header> headers = new HashMap<String, Header>();
        if (parts.length == 3) {
            path = parts[1];
            version = HTTPVersions.of(parts[2]);
        } else {
            version = HTTPVersions.of(parts[1]);
        }
        while ((line = reader.readLine()) != null && !line.isEmpty()) {
            Header header = Header.of(line);
            headers.put(header.getKey(), header);
        }
        B body = parser.parse(reader.getInputStreamForRemaining());
        return new HTTPRequest<B>(method, path, version, headers, body);
    }

    @NotNull
    public static HTTPRequest<Void> parse(@NotNull InputStream in) throws IOException {
        return HTTPRequest.parse(in, in1 -> null);
    }

    @NotNull
    public RequestMethod getMethod() {
        return this.method;
    }

    @Nullable
    public String getPath() {
        return this.path;
    }

    @NotNull
    public HTTPVersion getVersion() {
        return this.version;
    }

    @NotNull
    public Map<String, Header> getHeaders() {
        return Collections.unmodifiableMap(this.headers);
    }

    @Nullable
    public B getBody() {
        return this.body;
    }
}

