/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.color;

import de.linusdev.lutils.color.Color;
import de.linusdev.lutils.color.RGBAColor;
import org.jetbrains.annotations.NotNull;

public interface HSVAColor
extends Color {
    public double hue();

    public double saturation();

    public double value();

    public double alpha();

    @Override
    @NotNull
    default public RGBAColor toRGBAColor() {
        double hue = this.hue();
        double c = this.value() / 100.0 * (this.saturation() / 100.0);
        double x = c * (1.0 - Math.abs(hue / 60.0 % 2.0 - 1.0));
        double m = this.value() / 100.0 - c;
        if (hue < 60.0) {
            return Color.ofRGBA(c + m, x + m, 0.0 + m, this.alpha());
        }
        if (hue < 120.0) {
            return Color.ofRGBA(x + m, c + m, 0.0 + m, this.alpha());
        }
        if (hue < 180.0) {
            return Color.ofRGBA(0.0 + m, c + m, x + m, this.alpha());
        }
        if (hue < 240.0) {
            return Color.ofRGBA(0.0 + m, x + m, c + m, this.alpha());
        }
        if (hue < 300.0) {
            return Color.ofRGBA(x + m, 0.0 + m, c + m, this.alpha());
        }
        return Color.ofRGBA(c + m, 0.0 + m, x + m, this.alpha());
    }

    @Override
    @NotNull
    default public HSVAColor toHSVAColor() {
        return this;
    }
}

