/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.bitfield;

import de.linusdev.lutils.bitfield.IntBitFieldValue;
import org.jetbrains.annotations.NotNull;

public class IntVolatileBitfield<V extends IntBitFieldValue> {
    private volatile long value;

    public IntVolatileBitfield(long value) {
        this.value = value;
    }

    public IntVolatileBitfield() {
        this.value = 0L;
    }

    public void replaceWith(long value) {
        this.value = value;
    }

    public void reset() {
        this.value = 0L;
    }

    public boolean isSet(@NotNull V flag) {
        return (this.value & (long)flag.getValue()) == (long)flag.getValue();
    }

    public boolean isSet(long flag) {
        return (this.value & flag) == flag;
    }

    public void set(@NotNull V flag) {
        this.value |= (long)flag.getValue();
    }

    public void set(@NotNull V flag1, @NotNull V flag2) {
        this.value |= (long)(flag1.getValue() | flag2.getValue());
    }

    public void set(@NotNull V flag1, @NotNull V flag2, @NotNull V flag3) {
        this.value |= (long)(flag1.getValue() | flag2.getValue() | flag3.getValue());
    }

    public void set(@NotNull V flag1, @NotNull V flag2, @NotNull V flag3, @NotNull V flag4) {
        this.value |= (long)(flag1.getValue() | flag2.getValue() | flag3.getValue() | flag4.getValue());
    }

    @SafeVarargs
    public final void set(V ... flags) {
        for (V flag : flags) {
            this.value |= (long)flag.getValue();
        }
    }

    public void set(long flag) {
        this.value |= flag;
    }

    public void unset(@NotNull V flag) {
        this.value &= (long)(~flag.getValue());
    }

    public void unset(long flag) {
        this.value &= flag ^ 0xFFFFFFFFFFFFFFFFL;
    }
}

