/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.llist;

import de.linusdev.lutils.llist.LLinkedList;
import de.linusdev.lutils.llist.LLinkedListEntry;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LLinkedListIterator<O>
implements ListIterator<O>,
Iterator<O> {
    @NotNull
    private final LLinkedList<O> list;
    private int index;
    @Nullable
    private LLinkedListEntry<O> lastEntry;
    @NotNull
    private LLinkedListEntry<O> currentEntry;

    public LLinkedListIterator(@NotNull LLinkedList<O> list) {
        this.list = list;
        this.index = -1;
        this.currentEntry = list.getHead();
        this.lastEntry = null;
    }

    public LLinkedListIterator(@NotNull LLinkedList<O> list, int index, @Nullable LLinkedListEntry<O> lastEntry, @NotNull LLinkedListEntry<O> currentEntry) {
        this.list = list;
        this.index = index;
        this.currentEntry = currentEntry;
        this.lastEntry = lastEntry;
    }

    @Override
    public synchronized boolean hasNext() {
        return this.currentEntry.getNext() != null;
    }

    @Override
    public synchronized O next() {
        if (this.currentEntry.getNext() == null) {
            throw new NoSuchElementException();
        }
        this.lastEntry = this.currentEntry;
        this.currentEntry = this.currentEntry.getNext();
        ++this.index;
        return this.currentEntry.getValue();
    }

    @Override
    public boolean hasPrevious() {
        return false;
    }

    @Override
    public O previous() {
        throw new UnsupportedOperationException("This list cannot be traversed in reverse.");
    }

    @Override
    public int nextIndex() {
        return this.index + 1;
    }

    @Override
    public int previousIndex() {
        return this.index - 1;
    }

    @Override
    public void remove() {
        if (this.lastEntry == null) {
            throw new IllegalStateException("element cant be removed. next must be called");
        }
        this.list.removeEntry(this.currentEntry);
        this.lastEntry = null;
        --this.index;
    }

    @Override
    public void set(O o) {
        if (this.currentEntry == this.list.getHead()) {
            throw new IllegalStateException("Cannot set an element to the list head.");
        }
        this.currentEntry.setValue(o);
    }

    @Override
    public void add(O o) {
        this.list.add(this.currentEntry, new LLinkedListEntry<O>(o));
    }

    @NotNull
    LLinkedListEntry<O> getCurrentEntry() {
        return this.currentEntry;
    }

    @Nullable
    LLinkedListEntry<O> getLastEntry() {
        return this.lastEntry;
    }
}

