/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.color;

import de.linusdev.lutils.ansi.sgr.SGR;
import de.linusdev.lutils.ansi.sgr.SGRParameters;
import de.linusdev.lutils.color.Color;
import de.linusdev.lutils.color.HSVAColor;
import me.linusdev.data.SimpleDatable;
import org.jetbrains.annotations.NotNull;

public interface RGBAColor
extends SimpleDatable,
Color {
    public static final int RGB_INT_MIN = 0;
    public static final int RGB_INT_MAX = 255;
    public static final double RGB_DOUBLE_MIN = 0.0;
    public static final double RGB_DOUBLE_MAX = 1.0;

    public int getRed();

    public int getGreen();

    public int getBlue();

    public int getAlpha();

    public double red();

    public double green();

    public double blue();

    public double alpha();

    default public int toRGBAHex() {
        return (this.getRed() << 24) + (this.getGreen() << 16) + (this.getBlue() << 8) + this.getAlpha();
    }

    default public int toRGBHex() {
        return (this.getRed() << 16) + (this.getGreen() << 8) + this.getBlue();
    }

    @NotNull
    default public java.awt.Color toJavaAwtColor() {
        return new java.awt.Color(this.getRed(), this.getGreen(), this.getBlue(), this.getAlpha());
    }

    @NotNull
    default public SGR addToSgrAsForeground(@NotNull SGR sgr) {
        return sgr.add(SGRParameters.FOREGROUND_COLOR_24_BIT, String.valueOf(this.getRed()), String.valueOf(this.getGreen()), String.valueOf(this.getBlue()));
    }

    @NotNull
    default public SGR addToSgrAsBackground(@NotNull SGR sgr) {
        return sgr.add(SGRParameters.BACKGROUND_COLOR_24_BIT, String.valueOf(this.getRed()), String.valueOf(this.getGreen()), String.valueOf(this.getBlue()));
    }

    @NotNull
    default public Integer simplify() {
        return this.getAlpha() == 255 ? this.toRGBHex() : this.toRGBAHex();
    }

    @Override
    @NotNull
    default public RGBAColor toRGBAColor() {
        return this;
    }

    @Override
    @NotNull
    default public HSVAColor toHSVAColor() {
        double r = this.red();
        double g = this.green();
        double b = this.blue();
        if (r == g && g == b) {
            return Color.ofHSVA(0.0, 0.0, r * 100.0, this.alpha());
        }
        if (r > g && r > b) {
            double min = Math.min(g, b);
            return Color.ofHSVA(60.0 * ((g - b) / (r - min)) % 360.0, (r - min) * 100.0 / r, r * 100.0, this.alpha());
        }
        if (g > b) {
            double min = Math.min(r, b);
            return Color.ofHSVA((60.0 * ((b - r) / (g - min)) + 120.0) % 360.0, (g - min) * 100.0 / g, g * 100.0, this.alpha());
        }
        double min = Math.min(r, g);
        return Color.ofHSVA((60.0 * ((r - g) / (b - min)) + 120.0) % 360.0, (b - min) * 100.0 / b, b * 100.0, this.alpha());
    }
}

