/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.color;

import de.linusdev.lutils.color.HSVAColor;
import de.linusdev.lutils.color.RGBAColor;
import de.linusdev.lutils.color.impl.HSVAColorImpl;
import de.linusdev.lutils.color.impl.RGBAColorDoubleImpl;
import de.linusdev.lutils.color.impl.RGBAColorIntImpl;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;

public interface Color {
    @Contract(value="_, _, _ -> new", pure=true)
    @NotNull
    public static RGBAColor ofRGB(@Range(from=0L, to=255L) int r, @Range(from=0L, to=255L) int g, @Range(from=0L, to=255L) int b) {
        return new RGBAColorIntImpl(r, g, b, 255);
    }

    @Contract(value="_, _, _, _ -> new", pure=true)
    @NotNull
    public static RGBAColor ofRGBA(@Range(from=0L, to=255L) int r, @Range(from=0L, to=255L) int g, @Range(from=0L, to=255L) int b, @Range(from=0L, to=255L) int a) {
        return new RGBAColorIntImpl(r, g, b, a);
    }

    @Contract(value="_, -> new", pure=true)
    @NotNull
    public static RGBAColor ofRGBA(int hex) {
        return new RGBAColorIntImpl(hex & 0xFF000000, hex & 0xFF0000, hex & 0xFF00, hex & 0xFF);
    }

    @Contract(value="_, -> new", pure=true)
    @NotNull
    public static RGBAColor ofRGB(int hex) {
        return new RGBAColorIntImpl(hex & 0xFF0000, hex & 0xFF00, hex & 0xFF, 255);
    }

    @Contract(value="_, _, _ -> new", pure=true)
    @NotNull
    public static RGBAColor ofRGB(double r, double g, double b) {
        return new RGBAColorDoubleImpl(r, g, b, 1.0);
    }

    @Contract(value="_, _, _, _ -> new", pure=true)
    @NotNull
    public static RGBAColor ofRGBA(double r, double g, double b, double a) {
        return new RGBAColorDoubleImpl(r, g, b, a);
    }

    @Contract(value="_, _, _ -> new", pure=true)
    @NotNull
    public static HSVAColor ofHSV(double h, double s, double v) {
        return new HSVAColorImpl(h, s, v, 1.0);
    }

    @Contract(value="_, _, _, _ -> new", pure=true)
    @NotNull
    public static HSVAColor ofHSVA(double h, double s, double v, double a) {
        return new HSVAColorImpl(h, s, v, a);
    }

    @NotNull
    public RGBAColor toRGBAColor();

    @NotNull
    public HSVAColor toHSVAColor();
}

