/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.http_WIP;

import de.linusdev.lutils.http_WIP.body.BodySupplier;
import de.linusdev.lutils.http_WIP.header.Header;
import de.linusdev.lutils.http_WIP.method.Methods;
import de.linusdev.lutils.http_WIP.method.RequestMethod;
import de.linusdev.lutils.http_WIP.version.HTTPVersion;
import de.linusdev.lutils.http_WIP.version.HTTPVersions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HTTPRequestBuilder {
    public static final Charset CHARSET = StandardCharsets.UTF_8;
    public static final byte[] LINE_SEPARATOR = "\r\n".getBytes(CHARSET);
    public static final byte SPACE = 32;
    @NotNull
    private RequestMethod method;
    @Nullable
    private String path;
    @NotNull
    private HTTPVersion version;
    @NotNull
    private @NotNull Map<@NotNull String, @NotNull Header> headers = new HashMap<String, Header>();
    @Nullable
    private BodySupplier supplier;

    public HTTPRequestBuilder() {
        this.version = HTTPVersions.HTTP_1_1;
        this.method = Methods.GET;
    }

    public void setMethod(@NotNull RequestMethod method) {
        this.method = method;
    }

    public void setPath(@Nullable String path) {
        this.path = path;
    }

    public void setVersion(@NotNull HTTPVersion version) {
        this.version = version;
    }

    public void setBodySupplier(@Nullable BodySupplier supplier) {
        this.supplier = supplier;
    }

    public void setHeader(@NotNull String key, @Nullable String value) {
        if (value == null) {
            this.headers.remove(key);
        } else {
            this.headers.put(key, Header.of(key, value));
        }
    }

    public void setHeaders(@NotNull @NotNull Map<@NotNull String, @NotNull Header> headers) {
        this.headers = headers;
    }

    public void GET(@Nullable String path) {
        this.setMethod(Methods.GET);
        this.setPath(path);
    }

    public void POST(@Nullable String path, @NotNull BodySupplier supplier) {
        this.setMethod(Methods.POST);
        this.setPath(path);
        this.setBodySupplier(supplier);
    }

    public void build(@NotNull OutputStream stream, int maxBufferSize) throws IOException {
        stream.write(this.method.getName().getBytes(CHARSET));
        stream.write(32);
        if (this.path != null) {
            stream.write(this.path.getBytes(CHARSET));
            stream.write(32);
        }
        stream.write(this.version.asString().getBytes(CHARSET));
        stream.write(LINE_SEPARATOR);
        for (Header header : this.headers.values()) {
            stream.write(header.asString().getBytes(CHARSET));
            stream.write(LINE_SEPARATOR);
        }
        stream.write(LINE_SEPARATOR);
        if (this.supplier != null) {
            byte[] buffer = this.supplier.length() == -1 ? new byte[maxBufferSize] : new byte[Math.min(this.supplier.length(), maxBufferSize)];
            try (InputStream body = this.supplier.stream();){
                int len;
                while ((len = body.read(buffer)) != -1) {
                    stream.write(buffer, 0, len);
                }
            }
        }
    }
}

