/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.async.completeable;

import de.linusdev.lutils.async.ComputationResult;
import de.linusdev.lutils.async.Future;
import de.linusdev.lutils.async.PTask;
import de.linusdev.lutils.async.completeable.CompletableFuture;
import de.linusdev.lutils.async.exception.CannotQueueTaskException;
import de.linusdev.lutils.async.manager.AsyncManager;
import java.util.function.Consumer;
import org.jetbrains.annotations.NonBlocking;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CompletableTask<R, S>
implements PTask<R, S> {
    @NotNull
    private final AsyncManager asyncManager;

    public CompletableTask(@NotNull AsyncManager asyncManager) {
        this.asyncManager = asyncManager;
    }

    @Override
    @NotNull
    public ComputationResult<R, S> executeHere() {
        throw new UnsupportedOperationException("A completable task cannot be executed.");
    }

    @NotNull
    public CompletableFuture<R, S, CompletableTask<R, S>> consumeAndQueue(@Nullable Consumer<Future<R, S>> consumer) {
        CompletableFuture future = new CompletableFuture(this, this.asyncManager, true);
        if (consumer != null) {
            consumer.accept(future);
        }
        if (future.startIfNotCanceled()) {
            return future;
        }
        this.start(future);
        return future;
    }

    @NonBlocking
    protected abstract void start(@NotNull CompletableFuture<R, S, CompletableTask<R, S>> var1) throws CannotQueueTaskException;

    @Override
    @NotNull
    public AsyncManager getAsyncManager() {
        return this.asyncManager;
    }
}

