/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.async;

import de.linusdev.lutils.async.ComputationResult;
import de.linusdev.lutils.async.Future;
import de.linusdev.lutils.async.Task;
import de.linusdev.lutils.async.consumer.ResultConsumer;
import de.linusdev.lutils.async.exception.CancellationException;
import de.linusdev.lutils.async.manager.AsyncManager;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractFuture<R, S, T extends Task<R, S>>
implements Future<R, S> {
    @NotNull
    protected final AsyncManager asyncManager;
    @Nullable
    protected final T task;
    protected volatile boolean canceled = false;
    protected volatile boolean started = false;
    protected volatile boolean done = false;
    protected final Object lock = new Object();
    @Nullable
    protected volatile Consumer<Future<R, S>> before;
    @Nullable
    protected volatile ResultConsumer<R, S> then;
    @Nullable
    protected volatile ComputationResult<R, S> result;

    protected AbstractFuture(@Nullable T task, @NotNull AsyncManager asyncManager) {
        this.asyncManager = asyncManager;
        this.task = task;
    }

    @Nullable
    protected T getTask() {
        return this.task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Future<R, S> cancel() {
        Object object = this.lock;
        synchronized (object) {
            this.canceled = true;
            this.lock.notifyAll();
        }
        return this;
    }

    @Override
    public boolean isCanceled() {
        return this.canceled;
    }

    @Override
    public boolean hasStarted() {
        return this.started;
    }

    @Override
    public boolean isDone() {
        return this.done;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Future<R, S> beforeExecution(@NotNull Consumer<Future<R, S>> consumer) {
        Object object = this.lock;
        synchronized (object) {
            this.before = this.before == null ? consumer : this.before.andThen(consumer);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Future<R, S> then(@NotNull ResultConsumer<R, S> consumer) {
        Object object = this.lock;
        synchronized (object) {
            if (this.isDone()) {
                if (this.result.getResult() != null) {
                    consumer.consume(this.result.getResult(), this.result.getSecondary());
                } else {
                    consumer.onError(this.result.getError(), (Task<R, S>)this.task, this.result.getSecondary());
                }
            }
            this.then = this.then == null ? consumer : this.then.thenConsume(consumer);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public ComputationResult<R, S> get() throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            if (this.isCanceled()) {
                throw new CancellationException();
            }
            if (!this.isDone()) {
                this.lock.wait();
            }
            if (this.isCanceled()) {
                throw new CancellationException();
            }
            return this.result;
        }
    }

    @Override
    @NotNull
    public AsyncManager getAsyncManager() {
        return this.asyncManager;
    }
}

