/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.async.completeable;

import de.linusdev.lutils.async.AbstractFuture;
import de.linusdev.lutils.async.ComputationResult;
import de.linusdev.lutils.async.Future;
import de.linusdev.lutils.async.completeable.CompletableTask;
import de.linusdev.lutils.async.consumer.ResultConsumer;
import de.linusdev.lutils.async.error.AsyncError;
import de.linusdev.lutils.async.manager.AsyncManager;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompletableFuture<R, S, T extends CompletableTask<R, S>>
extends AbstractFuture<R, S, T> {
    protected CompletableFuture(@NotNull AsyncManager asyncManager) {
        this(null, asyncManager);
    }

    @NotNull
    public static <R, S> CompletableFuture<R, S, CompletableTask<R, S>> create(@NotNull AsyncManager asyncManager) {
        return new CompletableFuture(asyncManager);
    }

    public CompletableFuture(@Nullable T task, @NotNull AsyncManager asyncManager) {
        super(task, asyncManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void complete(@Nullable R result, @NotNull S secondary, @Nullable AsyncError error) {
        if (result == null && error == null) {
            throw new IllegalArgumentException("result or error must be not null.");
        }
        Object object = this.lock;
        synchronized (object) {
            this.result = new ComputationResult<R, S>(result, secondary, error);
            this.done = true;
            this.lock.notifyAll();
        }
        try {
            ResultConsumer then = this.then;
            if (then != null) {
                if (result != null) {
                    then.consume(result, secondary);
                } else {
                    then.onError(error, this.task, secondary);
                }
            }
        }
        catch (Throwable t) {
            this.getAsyncManager().onExceptionInListener(this, this.task, t);
        }
    }

    @Override
    @NotNull
    public Future<R, S> beforeExecution(@NotNull Consumer<Future<R, S>> consumer) {
        throw new UnsupportedOperationException("Completable future does not support before execution listener.");
    }

    @Override
    @NotNull
    public Future<R, S> cancel() {
        throw new UnsupportedOperationException("Completable future cannot be canceled.");
    }
}

