/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.llog.replacer;

import de.linusdev.llog.LLog;
import de.linusdev.llog.replacer.LocationObject;
import de.linusdev.llog.replacer.MutableReplaceObject;
import de.linusdev.llog.replacer.ReplaceObject;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LLogStringReplacer
implements ReplaceObject {
    @NotNull
    private final HashMap<String, ReplaceObject> objects = new HashMap();

    public LLogStringReplacer() {
        MutableReplaceObject self = new MutableReplaceObject();
        Path path = null;
        try {
            path = Paths.get(LLog.class.getProtectionDomain().getCodeSource().getLocation().toURI());
        }
        catch (URISyntaxException e) {
            System.err.println("llog: Cannot get jar path.");
        }
        LocationObject location = new LocationObject(path);
        self.addObject("location", location);
        this.objects.put("self", self);
    }

    @NotNull
    public String process(@NotNull String input) {
        Pattern pattern = Pattern.compile("\\{[^{}]+}");
        Matcher matcher = pattern.matcher((CharSequence)input);
        while (matcher.find()) {
            String matched = matcher.group();
            matched = matched.substring(1, matched.length() - 1);
            input = ((String)input).substring(0, matcher.start()) + this.replace(matched) + ((String)input).substring(matcher.end());
            matcher = pattern.matcher((CharSequence)input);
        }
        return input;
    }

    @NotNull
    private String replace(@NotNull String toReplace) {
        String[] names = toReplace.split("\\.");
        ReplaceObject current = this;
        String value = null;
        for (String name : names) {
            if (current == null) {
                value = null;
                break;
            }
            ReplaceObject object = current.getObject(name);
            if (object == null) {
                value = current.getProperty(name);
                current = null;
                continue;
            }
            value = current.toString();
            current = object;
        }
        return Objects.toString(value);
    }

    @Override
    @Nullable
    public ReplaceObject getObject(@NotNull String name) {
        return this.objects.get(name);
    }

    @Nullable
    public LLogStringReplacer addObject(@NotNull String name, @NotNull ReplaceObject object) {
        this.objects.put(name, object);
        return this;
    }

    @Override
    @Nullable
    public String getProperty(@NotNull String name) {
        return null;
    }
}

