/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.llog.impl.streamtext;

import de.linusdev.llog.base.LogLevel;
import de.linusdev.llog.base.LogSource;
import de.linusdev.llog.base.Logger;
import de.linusdev.llog.base.data.LogData;
import de.linusdev.llog.base.impl.StandardLogLevel;
import de.linusdev.llog.replacer.LLogStringReplacer;
import de.linusdev.lutils.ansi.sgr.SGR;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;

public class StreamTextLogger
implements Logger {
    @NotNull
    private static final DateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy HH:mm");
    @NotNull
    private final Writer writer;
    private final boolean autoFlush;
    private final boolean useAnsiColors;
    private int minimumLogLevel;

    public static void adjustReplacer(@NotNull LLogStringReplacer replacer) {
    }

    @NotNull
    public static Logger create(@NotNull Properties properties) {
        String logTo = properties.getProperty("logTo");
        boolean autoFlush = properties.getProperty("autoFlush", "false").equalsIgnoreCase("true");
        boolean useAnsiColors = properties.getProperty("useAnsiColors", "false").equalsIgnoreCase("true");
        if (logTo.equals("System.out")) {
            return new StreamTextLogger(System.out, StandardLogLevel.DEBUG.getLevel(), false, autoFlush, useAnsiColors);
        }
        Path path = Paths.get(logTo, new String[0]);
        try {
            Path parent = path.getParent();
            if (!Files.isDirectory(parent, new LinkOption[0])) {
                Files.createDirectories(parent, new FileAttribute[0]);
            }
            return new StreamTextLogger(Files.newOutputStream(path, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE), autoFlush, useAnsiColors);
        }
        catch (IOException e) {
            IllegalArgumentException ex = new IllegalArgumentException("StreamTextLogger: Cannot log to '" + path + "'.");
            ex.initCause(e);
            throw ex;
        }
    }

    public StreamTextLogger(@NotNull OutputStream stream, boolean autoFlush, boolean useAnsiColors) {
        this(stream, StandardLogLevel.DEBUG.getLevel(), true, autoFlush, useAnsiColors);
    }

    public StreamTextLogger(@NotNull OutputStream stream, int minimumLogLevel, boolean wrap, boolean autoFlush, boolean useAnsiColors) {
        this.useAnsiColors = useAnsiColors;
        this.autoFlush = autoFlush;
        this.writer = wrap ? new BufferedWriter(new OutputStreamWriter(stream, StandardCharsets.UTF_8)) : new OutputStreamWriter(stream, StandardCharsets.UTF_8);
        this.minimumLogLevel = minimumLogLevel;
    }

    @Override
    public void log(@NotNull LogLevel logLevel, @NotNull LogSource source, @NotNull LogData data) {
        if (this.minimumLogLevel <= logLevel.getLevel()) {
            if (data.canGenerateString()) {
                if (this.useAnsiColors) {
                    this.log((logLevel.getLevelNameColor() == null ? "" : logLevel.getLevelNameColor().addToSgrAsForeground(new SGR()).construct()) + logLevel.getName() + SGR.reset(), (logLevel.getSourceColor() == null ? "" : logLevel.getSourceColor().addToSgrAsForeground(new SGR()).construct()) + source.getName() + SGR.reset(), (logLevel.getTextColor() == null ? "" : logLevel.getTextColor().addToSgrAsForeground(new SGR()).construct()) + data.generateString() + SGR.reset());
                } else {
                    this.log(logLevel.getName(), source.getName(), data.generateString());
                }
            } else {
                this.log(logLevel.getName(), source.getName(), "unsupported log data.");
            }
        }
    }

    private void log(@NotNull String level, @NotNull String name, @NotNull String text) {
        String timestamp = dateFormat.format(new Date());
        try {
            this.writer.write("(" + timestamp + " " + level + " " + name + "): " + text + System.lineSeparator());
            if (this.autoFlush) {
                this.writer.flush();
            }
        }
        catch (IOException e) {
            System.err.println("logging failed: " + e.getMessage());
        }
    }

    @Override
    public boolean flush() {
        try {
            this.writer.flush();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public boolean isFlushable() {
        return true;
    }

    @Override
    public void setMinimumLogLevel(int level) {
        this.minimumLogLevel = level;
    }

    @Override
    public void shutdown() throws IOException {
        this.writer.close();
    }
}

