/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.llog;

import de.linusdev.llog.base.LogInstance;
import de.linusdev.llog.base.Logger;
import de.linusdev.llog.base.impl.StandardLogInstance;
import de.linusdev.llog.impl.nop.NOPLogger;
import de.linusdev.llog.replacer.LLogStringReplacer;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LLog {
    @NotNull
    public static Logger logger = new NOPLogger();
    @NotNull
    public static final StackWalker STACK_WALKER;

    @NotNull
    public static LogInstance getLogInstance() {
        Class<?> caller = STACK_WALKER.getCallerClass();
        return new StandardLogInstance(logger, caller);
    }

    @NotNull
    public static LogInstance getLogInstance(@NotNull String source, @Nullable Map<String, String> information) {
        return new StandardLogInstance(logger, source, information);
    }

    public static Logger createLogger(@NotNull String clazz, @NotNull Properties properties, @NotNull LLogStringReplacer replacer) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Class<?> loggerClass = Class.forName(clazz);
        if (!Logger.class.isAssignableFrom(loggerClass)) {
            throw new IllegalArgumentException(logger + " class does not implement the Logger interface.");
        }
        try {
            Method adjustMethod = loggerClass.getDeclaredMethod("adjustReplacer", LLogStringReplacer.class);
            if (!Modifier.isStatic(adjustMethod.getModifiers())) {
                System.err.println("adjustReplacer method of " + logger + " is not static.");
            } else {
                adjustMethod.setAccessible(true);
                adjustMethod.invoke(null, replacer);
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException adjustMethod) {
            // empty catch block
        }
        for (Map.Entry entry : properties.entrySet()) {
            entry.setValue(replacer.process((String)entry.getValue()));
        }
        Method createMethod = loggerClass.getDeclaredMethod("create", Properties.class);
        if (!Modifier.isStatic(createMethod.getModifiers())) {
            throw new IllegalArgumentException("create method of " + logger + " class is not static.");
        }
        if (!Logger.class.isAssignableFrom(createMethod.getReturnType())) {
            throw new IllegalArgumentException("create method of " + logger + " class does not return a Logger.");
        }
        createMethod.setAccessible(true);
        return (Logger)createMethod.invoke(null, properties);
    }

    public static void init(@NotNull Properties properties) {
        try {
            String logger = (String)properties.get("logger");
            LLog.logger.shutdown();
            LLog.logger = LLog.createLogger(logger, properties, new LLogStringReplacer());
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("Cannot start logger: " + e.getClass().getSimpleName() + ": " + e.getMessage() + ". Defaulting to NOP logger");
        }
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                logger.shutdown();
            }
            catch (Exception e) {
                System.err.println("LLog: Could not shutdown logger: " + e.getMessage());
            }
        }));
    }

    public static void init() {
        try (@Nullable InputStream propertiesFileStream = LLog.class.getClassLoader().getResourceAsStream("llog/llog.properties");){
            @NotNull Properties props = new Properties();
            if (propertiesFileStream != null) {
                props.load(propertiesFileStream);
                String noInit = props.getProperty("noInit", "false");
                if (noInit.equalsIgnoreCase("true")) {
                    System.out.println("LLog: noInit is set... Not initializing any Logger");
                    return;
                }
                LLog.init(props);
            } else {
                System.out.println("LLog: No '/llog/llog.properties' file found. Defaulting to NOP logger.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("Cannot start logger: " + e.getClass().getSimpleName() + ": " + e.getMessage() + ". Defaulting to NOP logger");
        }
    }

    @NotNull
    public static Logger getLogger() {
        return logger;
    }

    static {
        LLog.init();
        STACK_WALKER = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE);
    }
}

