/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.data.so;

import de.linusdev.data.entry.Entry;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SAOEntryImpl<O>
implements Entry<String, O> {
    @NotNull
    private final String key;
    @Nullable
    private O value;
    @Nullable
    private Function<Entry<String, O>, O> getter = null;
    @Nullable
    private BiConsumer<Entry<String, O>, O> setter = null;

    private SAOEntryImpl() {
        this.key = "";
    }

    public SAOEntryImpl(@NotNull String key, @Nullable O value) {
        this.key = key;
        this.value = value;
    }

    public SAOEntryImpl(@NotNull String key) {
        this.key = key;
        this.value = null;
    }

    @Override
    @Nullable
    public O getValue() {
        if (this.getter != null) {
            return this.getter.apply(this);
        }
        return this.value;
    }

    @Override
    public void setValue(@Nullable O value) {
        if (this.setter != null) {
            this.setter.accept(this, value);
            return;
        }
        this.value = value;
    }

    @Override
    public void overwriteGetValue(@Nullable Function<Entry<String, O>, O> getter) {
        if (this.getter != null) {
            throw new UnsupportedOperationException("This entry can only be contained in a single data.");
        }
        this.getter = getter;
    }

    @Override
    public void overwriteSetValue(@Nullable BiConsumer<Entry<String, O>, O> setter) {
        if (this.setter != null) {
            throw new UnsupportedOperationException("This entry can only be contained in a single data.");
        }
        this.setter = setter;
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    public boolean equalsKey(String key) {
        return this.key.equals(key);
    }
}

