/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.data.refl;

import de.linusdev.data.OptionalValue;
import de.linusdev.data.refl.OptValue;
import de.linusdev.data.refl.Value;
import de.linusdev.data.so.SOData;
import de.linusdev.data.so.SODatable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.jetbrains.annotations.Nullable;

public interface AutoSODatable
extends SODatable {
    default public SOData getData(@Nullable SOData data) {
        Field[] fields = this.getClass().getDeclaredFields();
        if (data == null) {
            data = SOData.newOrderedDataWithKnownSize(fields.length);
        }
        for (Field field : fields) {
            int mods = field.getModifiers();
            if (Modifier.isTransient(mods) || Modifier.isStatic(mods)) continue;
            if (!Modifier.isPublic(mods)) {
                field.setAccessible(true);
            }
            Value valueAnno = field.getAnnotation(Value.class);
            OptValue optAnno = field.getAnnotation(OptValue.class);
            String key = optAnno == null ? (valueAnno == null ? field.getName() : valueAnno.value()) : optAnno.value();
            try {
                Object value = field.get(this);
                if (optAnno != null) {
                    if (value == null) continue;
                    data.addIfOptionalExists(key, (OptionalValue)value);
                    continue;
                }
                if (valueAnno != null && !valueAnno.addIfNull()) {
                    data.addIfNotNull(key, value);
                    continue;
                }
                data.add(key, value);
            }
            catch (IllegalAccessException ignored) {
                System.err.println("Cannot access field '" + field.getName() + "' in class '" + this.getClass().getCanonicalName() + "'.");
            }
        }
        return data;
    }

    @Override
    default public SOData getData() {
        return this.getData(null);
    }
}

