/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.data.implemantations;

import de.linusdev.data.entry.Entry;
import de.linusdev.data.entry.MapEntryImpl;
import de.linusdev.data.so.SAOEntryImpl;
import de.linusdev.data.so.SOData;
import java.util.Iterator;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SODataMapImpl
implements SOData {
    protected final Map<String, Object> entries;

    public SODataMapImpl(Map<String, Object> map) {
        this.entries = map;
    }

    @Override
    public boolean add(@NotNull String key, @Nullable Object value) {
        this.entries.put(key, value);
        return true;
    }

    @Override
    public void addEntry(@NotNull Entry<String, Object> entry) {
        this.entries.put(entry.getKey(), entry.getValue());
        entry.overwriteGetValue(stringObjectEntry -> this.entries.get(stringObjectEntry.getKey()));
        entry.overwriteSetValue((stringObjectEntry, o) -> {
            this.entries.put((String)stringObjectEntry.getKey(), o);
            stringObjectEntry.setValue(o);
        });
    }

    @Override
    @Nullable
    public Entry<String, Object> remove(@NotNull String key) {
        return new SAOEntryImpl<Object>(key, this.entries.remove(key));
    }

    @Override
    @Nullable
    public Entry<String, Object> getEntry(@NotNull String key) {
        return new MapEntryImpl(this.entries, key);
    }

    @Override
    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    @Override
    @NotNull
    public Iterator<Entry<String, Object>> iterator() {
        return new Iterator<Entry<String, Object>>(){
            final Iterator<String> keyIterator;
            {
                this.keyIterator = SODataMapImpl.this.entries.keySet().stream().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.keyIterator.hasNext();
            }

            @Override
            public Entry<String, Object> next() {
                return new MapEntryImpl(SODataMapImpl.this.entries, this.keyIterator.next());
            }
        };
    }
}

