/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.data;

import de.linusdev.data.ContentOnlyData;
import de.linusdev.data.entry.Entry;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface DataWrapper<K, V>
extends ContentOnlyData<K, V> {
    public K getKey();

    @Override
    @NotNull
    public Entry<K, V> getEntry(@NotNull K var1);

    default public void set(@NotNull V obj) {
        this.getEntry(this.getKey()).setValue(obj);
    }

    default public V get() {
        return this.getEntry(this.getKey()).getValue();
    }

    @Override
    default public boolean add(@NotNull K key, @Nullable V value) {
        throw new UnsupportedOperationException("This data can only have a single entry, use the set method instead");
    }

    @Override
    default public void addEntry(@NotNull Entry<K, V> entry) {
        throw new UnsupportedOperationException("This data can only have a single entry, use the set method instead");
    }

    @Override
    @Nullable
    default public Entry<K, V> remove(@NotNull K key) {
        throw new UnsupportedOperationException("This data can only have a single entry, which cannot be removed. Use the set method instead");
    }

    @Override
    default public boolean isEmpty() {
        return false;
    }

    @Override
    default public int size() {
        return 1;
    }

    @Override
    @NotNull
    default public Iterator<Entry<K, V>> iterator() {
        return new Iterator<Entry<K, V>>(){
            boolean retrieved = false;

            @Override
            public boolean hasNext() {
                return !this.retrieved;
            }

            @Override
            public Entry<K, V> next() {
                if (this.retrieved) {
                    throw new NoSuchElementException();
                }
                this.retrieved = true;
                return DataWrapper.this.getEntry(DataWrapper.this.getKey());
            }
        };
    }
}

