/*
 * Decompiled with CFR 0.152.
 */
package de.li2b2.shrine.broker.standalone;

import de.li2b2.shrine.broker.admin.BrokerQueryManager;
import de.li2b2.shrine.broker.standalone.Configuration;
import de.li2b2.shrine.broker.standalone.TokenManagerImpl;
import de.sekmi.li2b2.api.crc.QueryManager;
import de.sekmi.li2b2.api.ont.Ontology;
import de.sekmi.li2b2.api.pm.ProjectManager;
import de.sekmi.li2b2.services.impl.OntologyImpl;
import de.sekmi.li2b2.services.token.TokenManager;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Paths;
import javax.sql.DataSource;
import org.aktin.broker.RequestTypeManager;
import org.aktin.broker.auth.AuthCache;
import org.aktin.broker.db.AggregatorBackend;
import org.aktin.broker.db.AggregatorImpl;
import org.aktin.broker.db.BrokerBackend;
import org.aktin.broker.db.BrokerImpl;
import org.aktin.broker.server.Aggregator;
import org.aktin.broker.server.Broker;
import org.glassfish.hk2.utilities.binding.AbstractBinder;

public class MyBinder
extends AbstractBinder {
    private DataSource ds;
    private QueryManager qm;
    private ProjectManager pm;
    private Ontology ont;
    private Configuration config;
    private BrokerBackend broker;
    private AggregatorBackend aggregator;

    public MyBinder(DataSource ds, ProjectManager pm, Configuration config) {
        this.ds = ds;
        this.pm = pm;
        this.config = config;
    }

    protected void configure() {
        try {
            this.broker = new BrokerImpl(this.ds, Paths.get(this.config.getBrokerDataPath(), new String[0]));
            this.aggregator = new AggregatorImpl(this.ds, Paths.get(this.config.getAggregatorDataPath(), new String[0]));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.bind(this.broker).to(BrokerBackend.class);
        this.bind(this.aggregator).to(AggregatorBackend.class);
        this.bind(new AuthCache(this.broker)).to(AuthCache.class);
        this.bind(new RequestTypeManager()).to(RequestTypeManager.class);
        this.qm = new BrokerQueryManager((Broker)this.broker, (Aggregator)this.aggregator);
        this.bind(this.qm).to(QueryManager.class);
        this.bind(this.pm).to(ProjectManager.class);
        try {
            this.ont = OntologyImpl.parse((InputStream)this.config.readOntologyXML());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        this.bind(this.ont).to(Ontology.class);
        this.bind((Object)new TokenManagerImpl()).to(TokenManager.class);
    }
}

