/*
 * Decompiled with CFR 0.152.
 */
package de.li2b2.shrine.broker.standalone;

import de.li2b2.shrine.broker.standalone.Configuration;
import de.li2b2.shrine.broker.standalone.TokenManagerImpl;
import de.sekmi.li2b2.api.crc.QueryManager;
import de.sekmi.li2b2.api.ont.Ontology;
import de.sekmi.li2b2.api.pm.ProjectManager;
import de.sekmi.li2b2.services.impl.OntologyImpl;
import de.sekmi.li2b2.services.token.TokenManager;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Paths;
import javax.sql.DataSource;
import org.aktin.broker.RequestTypeManager;
import org.aktin.broker.auth.AuthCache;
import org.aktin.broker.db.AggregatorBackend;
import org.aktin.broker.db.AggregatorImpl;
import org.aktin.broker.db.BrokerBackend;
import org.aktin.broker.db.BrokerImpl;
import org.glassfish.hk2.utilities.binding.AbstractBinder;

public class MyBinder
extends AbstractBinder {
    private DataSource ds;
    private QueryManager qm;
    private ProjectManager pm;
    private Ontology ont;
    private Configuration config;

    public MyBinder(DataSource ds, QueryManager qm, ProjectManager pm, Configuration config) {
        this.qm = qm;
        this.ds = ds;
        this.pm = pm;
        this.config = config;
    }

    protected void configure() {
        BrokerImpl backend = new BrokerImpl(this.ds);
        this.bind(backend).to(BrokerBackend.class);
        this.bind(new AuthCache((BrokerBackend)backend)).to(AuthCache.class);
        try {
            AggregatorImpl adb = new AggregatorImpl(this.ds, Paths.get(this.config.getAggregatorDataPath(), new String[0]));
            this.bind(adb).to(AggregatorBackend.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.bind(new RequestTypeManager()).to(RequestTypeManager.class);
        this.bind(this.qm).to(QueryManager.class);
        this.bind(this.pm).to(ProjectManager.class);
        try {
            this.ont = OntologyImpl.parse((InputStream)this.config.readOntologyXML());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        this.bind(this.ont).to(Ontology.class);
        this.bind((Object)new TokenManagerImpl()).to(TokenManager.class);
    }
}

