/*
 * Decompiled with CFR 0.152.
 */
package de.li2b2.shrine.broker.standalone;

import de.li2b2.shrine.broker.admin.BrokerQueryManager;
import de.li2b2.shrine.broker.standalone.Configuration;
import de.li2b2.shrine.broker.standalone.DefaultConfiguration;
import de.li2b2.shrine.broker.standalone.MyBinder;
import de.li2b2.shrine.broker.standalone.PropertyFileAPIKeys;
import de.li2b2.shrine.broker.standalone.db.HSQLDataSource;
import de.sekmi.li2b2.api.crc.QueryManager;
import de.sekmi.li2b2.api.pm.ProjectManager;
import de.sekmi.li2b2.api.pm.User;
import de.sekmi.li2b2.services.OntologyService;
import de.sekmi.li2b2.services.PMService;
import de.sekmi.li2b2.services.QueryToolService;
import de.sekmi.li2b2.services.Webadmin;
import de.sekmi.li2b2.services.Webclient;
import de.sekmi.li2b2.services.WorkplaceService;
import de.sekmi.li2b2.services.impl.ProjectManagerImpl;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.sql.SQLException;
import javax.servlet.Servlet;
import javax.sql.DataSource;
import liquibase.exception.LiquibaseException;
import org.aktin.broker.AggregatorEndpoint;
import org.aktin.broker.BrokerEndpoint;
import org.aktin.broker.db.LiquibaseWrapper;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.servlet.ServletContainer;

public class HttpServer {
    private Configuration config;
    private ResourceConfig rc;
    private Server jetty;
    private DataSource ds;
    private BrokerQueryManager qm;
    private ProjectManager pm;

    public HttpServer(Configuration config) throws SQLException, IOException {
        this.config = config;
        this.ds = new HSQLDataSource(config.getDatabasePath());
        this.initialiseDatabase();
        this.rc = new ResourceConfig();
        try (InputStream in = config.readAPIKeyProperties();){
            this.rc.register((Object)new PropertyFileAPIKeys(in));
        }
        this.register(BrokerEndpoint.class);
        this.register(AggregatorEndpoint.class);
        this.register(PMService.class);
        this.register(QueryToolService.class);
        this.register(WorkplaceService.class);
        this.register(OntologyService.class);
        this.register(Webclient.class);
        this.register(Webadmin.class);
        this.loadLi2b2Backend();
    }

    private void initialiseDatabase() throws SQLException {
        try (LiquibaseWrapper w = new LiquibaseWrapper(this.ds.getConnection());){
            w.update();
        }
        catch (LiquibaseException e) {
            throw new SQLException("Unable to initialise database", e);
        }
    }

    private void loadLi2b2Backend() throws IOException {
        this.pm = new ProjectManagerImpl();
        User user = this.pm.addUser("demo");
        user.setPassword("demouser".toCharArray());
        this.pm.addProject("Demo", "li2b2 Demo").addUserRoles(user, new String[]{"USER", "EDITOR", "DATA_OBFSC", "DATA_AGG"});
    }

    public final void register(Class<?> componentClass) {
        this.rc.register(componentClass);
    }

    protected void start_local(int port) throws Exception {
        this.start(new InetSocketAddress(InetAddress.getLoopbackAddress(), port));
    }

    public URI getBrokerServiceURI() {
        return this.jetty.getURI().resolve("/broker/");
    }

    public void start(InetSocketAddress addr) throws Exception {
        ServletContextHandler context = new ServletContextHandler(1);
        context.setContextPath("/");
        this.jetty = new Server(addr);
        this.jetty.setHandler((Handler)context);
        this.qm = new BrokerQueryManager(new URI("http://localhost:" + addr.getPort() + "/broker/"));
        this.rc.register((Object)new MyBinder(this.ds, (QueryManager)this.qm, this.pm, this.config));
        ServletHolder jersey = new ServletHolder((Servlet)new ServletContainer(this.rc));
        context.addServlet(jersey, "/*");
        this.jetty.start();
    }

    public void join() throws InterruptedException {
        this.jetty.join();
    }

    public void destroy() throws Exception {
        this.jetty.destroy();
    }

    public void stop() throws Exception {
        this.jetty.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        InetAddress bindaddr;
        int port;
        if (args.length == 0) {
            port = 8080;
            bindaddr = InetAddress.getLoopbackAddress();
        } else if (args.length == 1) {
            int colon = args[0].indexOf(58);
            if (colon == -1) {
                bindaddr = InetAddress.getLoopbackAddress();
                port = Integer.parseInt(args[0]);
            } else {
                bindaddr = InetAddress.getByName(args[0].substring(0, colon));
                port = Integer.parseInt(args[0].substring(colon + 1));
            }
        } else {
            System.err.println("Too many command line arguments!");
            System.err.println("Usage: " + HttpServer.class.getCanonicalName() + " [[hostname:]port]");
            System.exit(-1);
            return;
        }
        Class.forName("org.hsqldb.jdbcDriver");
        HttpServer server = new HttpServer(new DefaultConfiguration());
        try {
            server.start(new InetSocketAddress(bindaddr, port));
            System.err.println("Broker service at: " + server.getBrokerServiceURI());
            server.join();
        }
        finally {
            server.destroy();
        }
    }
}

