/*
 * Decompiled with CFR 0.152.
 */
package de.sekmi.li2b2.client.pm;

import de.sekmi.li2b2.client.CellClient;
import de.sekmi.li2b2.client.Li2b2Client;
import de.sekmi.li2b2.client.pm.Role;
import de.sekmi.li2b2.client.pm.User;
import de.sekmi.li2b2.client.pm.UserConfiguration;
import de.sekmi.li2b2.hive.Credentials;
import de.sekmi.li2b2.hive.ErrorResponseException;
import de.sekmi.li2b2.hive.HiveException;
import de.sekmi.li2b2.hive.HiveRequest;
import de.sekmi.li2b2.hive.pm.Param;
import java.net.URL;
import java.util.Objects;
import java.util.logging.Logger;
import javax.xml.bind.JAXBException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class PMClient
extends CellClient {
    private static final Logger log = Logger.getLogger(PMClient.class.getName());
    public static final String XMLNS = "http://www.i2b2.org/xsd/cell/pm/1.1/";

    public PMClient(Li2b2Client client, URL serviceUrl) {
        super(client, serviceUrl);
    }

    public void changePassword(String user, String domain, char[] oldPassword, char[] newPassword) throws ErrorResponseException, HiveException {
        throw new UnsupportedOperationException("not implemented");
    }

    public UserConfiguration requestUserConfiguration() throws ErrorResponseException, HiveException {
        HiveRequest req = this.createRequestMessage();
        Element el = req.addBodyElement(XMLNS, "get_user_configuration");
        el.appendChild(el.getOwnerDocument().createElement("project")).setTextContent(this.client.getProjectId());
        Element n = this.submitRequestWithResponseContent(req, "getServices", XMLNS, "configure");
        UserConfiguration config = UserConfiguration.parse(n);
        if (config.getSessionKey() != null) {
            log.info("Using session key for future calls: " + config.getSessionKey());
            this.client.setCredentials(new Credentials(config.getUserDomain(), config.getUserName(), config.getSessionKey(), true));
        }
        return config;
    }

    public User[] getUsers() throws HiveException {
        HiveRequest req = this.createRequestMessage();
        Element el = req.addBodyElement(XMLNS, "get_all_user");
        el.setPrefix("pm");
        el.setTextContent(" ");
        Element n = this.submitRequestWithResponseContent(req, "getServices", XMLNS, "users");
        User[] users = User.parse(n);
        return users;
    }

    public User getUser(String user_name) throws HiveException {
        HiveRequest req = this.createRequestMessage();
        Element el = req.addBodyElement(XMLNS, "get_user");
        el.setPrefix("pm");
        el.setTextContent(user_name);
        Element n = this.submitRequestWithResponseContent(req, "getServices", XMLNS, "user");
        User user = User.parseUser(n);
        return user;
    }

    public void setUser(User user) throws HiveException {
        this.setUser(user.user_name, user.full_name, user.email, user.password, user.is_admin);
    }

    public void setUser(String user_name, String full_name, String email, String password, boolean is_admin) throws HiveException {
        Objects.requireNonNull(user_name, "User name must be non-null");
        Objects.requireNonNull(password, "password must be non-null");
        HiveRequest req = this.createRequestMessage();
        Element el = req.addBodyElement(XMLNS, "set_user");
        el.setPrefix("pm");
        this.appendTextElement(el, "user_name", user_name);
        if (full_name != null) {
            this.appendTextElement(el, "full_name", full_name);
        }
        if (email != null) {
            this.appendTextElement(el, "email", email);
        }
        if (password != null) {
            this.appendTextElement(el, "password", password);
        }
        this.appendTextElement(el, "is_admin", Boolean.toString(is_admin));
        Element n = this.submitRequestWithResponseContent(req, "getServices", XMLNS, "response");
        n.getTextContent();
    }

    public void deleteUser(String user_name) throws HiveException, ErrorResponseException {
        HiveRequest req = this.createRequestMessage();
        Element el = req.addBodyElement(XMLNS, "delete_user");
        el.setPrefix("pm");
        el.setTextContent(user_name);
        Element n = this.submitRequestWithResponseContent(req, "getServices", XMLNS, "response");
        n.getTextContent();
    }

    public Role[] getRoles() throws HiveException {
        return this.getAllRoles(null, null);
    }

    public Role[] getRoles(String project_id) throws HiveException {
        return this.getAllRoles(null, project_id);
    }

    public String[] getRoles(String userId, String projectId) throws HiveException {
        Role[] roles = this.getAllRoles(userId, projectId);
        String[] str = new String[roles.length];
        for (int i = 0; i < roles.length; ++i) {
            str[i] = roles[i].role;
        }
        return str;
    }

    private Role[] getAllRoles(String user_name, String project_id) throws HiveException {
        HiveRequest req = this.createRequestMessage();
        Element el = req.addBodyElement(XMLNS, "get_all_role");
        el.setPrefix("pm");
        this.appendOptionalElement(el, "user_name", user_name);
        this.appendOptionalElement(el, "project_id", project_id);
        Element n = this.submitRequestWithResponseContent(req, "getServices", XMLNS, "roles");
        Role[] roles = Role.parse(n);
        return roles;
    }

    public void setRole(String user_name, String role, String project_id) throws HiveException, ErrorResponseException {
        HiveRequest req = this.createRequestMessage();
        Element el = req.addBodyElement(XMLNS, "set_role");
        el.setPrefix("pm");
        el.appendChild(el.getOwnerDocument().createElement("user_name")).setTextContent(user_name);
        el.appendChild(el.getOwnerDocument().createElement("role")).setTextContent(role);
        el.appendChild(el.getOwnerDocument().createElement("project_id")).setTextContent(project_id);
        Element n = this.submitRequestWithResponseContent(req, "getServices", XMLNS, "response");
        n.getTextContent();
    }

    public void deleteRole(String user_name, String role, String project_id) throws HiveException, ErrorResponseException {
        HiveRequest req = this.createRequestMessage();
        Element el = req.addBodyElement(XMLNS, "delete_role");
        el.setPrefix("pm");
        el.appendChild(el.getOwnerDocument().createElement("user_name")).setTextContent(user_name);
        el.appendChild(el.getOwnerDocument().createElement("role")).setTextContent(role);
        el.appendChild(el.getOwnerDocument().createElement("project_id")).setTextContent(project_id);
        Element n = this.submitRequestWithResponseContent(req, "getServices", XMLNS, "response");
        n.getTextContent();
    }

    public void addUserParam(String user_name, String paramType, String paramName, String paramValue) throws HiveException {
        HiveRequest req = this.createRequestMessage();
        Element el = req.addBodyElement(XMLNS, "set_user_param");
        el.setPrefix("pm");
        el.appendChild(el.getOwnerDocument().createElement("user_name")).setTextContent(user_name);
        Element par = (Element)el.appendChild(el.getOwnerDocument().createElement("param"));
        par.setAttribute("datatype", paramType);
        par.setAttribute("name", paramName);
        par.setTextContent(paramValue);
        Element n = this.submitRequestWithResponseContent(req, "getServices", XMLNS, "response");
        n.getTextContent();
    }

    public Param[] getUserParams(String user_name) throws HiveException, ErrorResponseException {
        HiveRequest req = this.createRequestMessage();
        Element el = req.addBodyElement(XMLNS, "get_all_user_param");
        el.setPrefix("pm");
        el.appendChild(el.getOwnerDocument().createElement("user_name")).setTextContent(user_name);
        Element n = this.submitRequestWithResponseContent(req, "getServices", XMLNS, "users");
        User[] users = User.parse(n);
        if (users.length != 1 || users[0].user_name == null || !users[0].user_name.equals(user_name)) {
            throw new HiveException("No/illegal params response for user " + user_name);
        }
        return users[0].param;
    }

    public void deleteUserParam(int id) throws HiveException {
        HiveRequest req = this.createRequestMessage();
        Element el = req.addBodyElement(XMLNS, "delete_user_param");
        el.setPrefix("pm");
        el.setTextContent(Integer.toString(id));
        Element n = this.submitRequestWithResponseContent(req, "getServices", XMLNS, "response");
        n.getTextContent();
    }

    public void deleteHiveParam(int id) throws HiveException {
        HiveRequest req = this.createRequestMessage();
        Element el = req.addBodyElement(XMLNS, "delete_global");
        el.setPrefix("pm");
        el.setTextContent(Integer.toString(id));
        Element n = this.submitRequestWithResponseContent(req, "getServices", XMLNS, "response");
        n.getTextContent();
    }

    public Param[] getHiveParams(String project_path) throws HiveException {
        HiveRequest req = this.createRequestMessage();
        Element el = req.addBodyElement(XMLNS, "get_all_global");
        el.setTextContent(project_path);
        el.setPrefix("pm");
        Element n = this.submitRequestWithResponseContent(req, "getServices", XMLNS, "params");
        try {
            return Param.parseNodeList((NodeList)n.getChildNodes());
        }
        catch (JAXBException e) {
            throw new HiveException("Unable to parse response params", (Throwable)e);
        }
    }

    public Param[] getProjectParams(String projectId) throws HiveException {
        HiveRequest req = this.createRequestMessage();
        Element el = req.addBodyElement(XMLNS, "get_all_project_param");
        el.setPrefix("pm");
        el.setTextContent(projectId);
        Element n = this.submitRequestWithResponseContent(req, "getServices", XMLNS, "params");
        try {
            return Param.parseNodeList((NodeList)n.getChildNodes());
        }
        catch (JAXBException e) {
            throw new HiveException("Unable to parse response params", (Throwable)e);
        }
    }

    public void deleteProjectParam(int id) throws HiveException {
        HiveRequest req = this.createRequestMessage();
        Element el = req.addBodyElement(XMLNS, "delete_project_param");
        el.setPrefix("pm");
        el.setTextContent(Integer.toString(id));
        Element n = this.submitRequestWithResponseContent(req, "getServices", XMLNS, "response");
        n.getTextContent();
    }

    public void addHiveParam(String paramType, String paramName, String paramValue) throws HiveException {
        HiveRequest req = this.createRequestMessage();
        Element el = req.addBodyElement(XMLNS, "set_global");
        el.setPrefix("pm");
        el.appendChild(el.getOwnerDocument().createElement("project_path")).setTextContent("/");
        el.appendChild(el.getOwnerDocument().createElement("can_override")).setTextContent("Y");
        Element par = (Element)el.appendChild(el.getOwnerDocument().createElement("param"));
        par.setAttribute("datatype", paramType);
        par.setAttribute("name", paramName);
        par.setTextContent(paramValue);
        Element n = this.submitRequestWithResponseContent(req, "getServices", XMLNS, "response");
        n.getTextContent();
    }

    public void addProjectParam(String projectId, String paramType, String paramName, String paramValue) throws HiveException {
        HiveRequest req = this.createRequestMessage();
        Element el = req.addBodyElement(XMLNS, "set_project_param");
        el.setPrefix("pm");
        el.setAttribute("id", projectId);
        Element par = (Element)el.appendChild(el.getOwnerDocument().createElement("param"));
        par.setAttribute("datatype", paramType);
        par.setAttribute("name", paramName);
        par.setTextContent(paramValue);
        Element n = this.submitRequestWithResponseContent(req, "getServices", XMLNS, "response");
        n.getTextContent();
    }
}

