/*
 * Decompiled with CFR 0.152.
 */
package de.sekmi.li2b2.client.ont;

import de.sekmi.li2b2.client.Li2b2Client;
import de.sekmi.li2b2.client.ont.Concept;
import de.sekmi.li2b2.client.ont.OntologyClient;
import de.sekmi.li2b2.hive.HiveException;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XMLExport {
    private XMLStreamWriter w;
    private OntologyClient o;
    private boolean indent;
    private boolean includeMetadata;

    public XMLExport(OntologyClient c, Writer writer) throws XMLStreamException, FactoryConfigurationError {
        this.o = c;
        this.indent = true;
        this.includeMetadata = true;
        this.w = XMLOutputFactory.newInstance().createXMLStreamWriter(writer);
    }

    private void newlineAndIndent(int level) throws XMLStreamException {
        if (!this.indent) {
            return;
        }
        StringBuilder b = new StringBuilder(15);
        b.append("\n\t");
        for (int i = 0; i < level; ++i) {
            b.append('\t');
        }
        this.w.writeCharacters(b.toString());
    }

    private void writeSimpleTextElement(int level, String name, String value) throws XMLStreamException {
        this.newlineAndIndent(level + 1);
        this.w.writeStartElement(name);
        this.w.writeCharacters(value);
        this.w.writeEndElement();
    }

    private void startDocument() throws XMLStreamException {
        this.w.writeStartDocument();
        this.w.writeCharacters("\n");
        this.w.writeStartElement("ontology");
    }

    private void endDocument() throws XMLStreamException {
        if (this.indent) {
            this.w.writeCharacters("\n");
        }
        this.w.writeEndElement();
        this.w.writeEndDocument();
        this.w.flush();
    }

    public void exportAll() throws XMLStreamException, HiveException {
        this.startDocument();
        this.writeConcepts(this.o.getCategories(), 0);
        this.endDocument();
    }

    public void exportSubtree(String key) throws XMLStreamException, HiveException {
        this.startDocument();
        this.writeConcepts(this.o.getChildren(key, this.includeMetadata), 0);
        this.endDocument();
    }

    private void writeConcepts(Concept[] c, int level) throws XMLStreamException, HiveException {
        for (int i = 0; i < c.length; ++i) {
            this.writeConcept(c[i], level);
        }
    }

    private void writeConcept(Concept c, int level) throws XMLStreamException, HiveException {
        Element metadataxml;
        this.newlineAndIndent(level);
        this.w.writeStartElement("concept");
        this.w.writeAttribute("key", c.key);
        if (c.basecode != null) {
            this.w.writeAttribute("code", c.basecode);
        }
        if (c.totalnum != null) {
            this.w.writeAttribute("patient-count", c.totalnum.toString());
        }
        this.newlineAndIndent(level + 1);
        this.w.writeStartElement("name");
        this.w.writeCharacters(c.name);
        this.w.writeEndElement();
        if (c.tooltip != null && c.tooltip.length() != 0) {
            this.writeSimpleTextElement(level, "tooltip", c.tooltip);
        }
        if ((metadataxml = c.getMetadataXML()) != null) {
            boolean hasConstraints = false;
            String datatype = null;
            ArrayList<String> units = new ArrayList<String>();
            NodeList nl = metadataxml.getElementsByTagName("DataType");
            if (nl.getLength() == 1) {
                datatype = nl.item(0).getTextContent();
                hasConstraints = true;
            }
            if ((nl = metadataxml.getElementsByTagName("NormalUnits")).getLength() >= 1) {
                for (int i = 0; i < nl.getLength(); ++i) {
                    String u = nl.item(0).getTextContent();
                    if (u == null || u.length() <= 0) continue;
                    units.add(u);
                }
                if (units.size() > 0) {
                    hasConstraints = true;
                }
            }
            ArrayList<String> enumValues = new ArrayList<String>();
            ArrayList<String> enumLabels = new ArrayList<String>();
            nl = metadataxml.getElementsByTagName("EnumValues");
            if (nl.getLength() == 1 && nl.item(0).getFirstChild() != null) {
                Element ev = (Element)nl.item(0);
                nl = ev.getChildNodes();
                for (int i = 0; i < nl.getLength(); ++i) {
                    if (nl.item(i).getNodeType() != 1 || !nl.item(i).getLocalName().contentEquals("Val")) continue;
                    Element val = (Element)nl.item(i);
                    enumValues.add(val.getTextContent());
                    enumLabels.add(val.getAttribute("description"));
                }
            }
            if (hasConstraints) {
                int i;
                this.newlineAndIndent(level + 1);
                this.w.writeStartElement("constraints");
                if (datatype != null) {
                    this.writeSimpleTextElement(level + 1, "datatype", datatype);
                }
                for (i = 0; i < units.size(); ++i) {
                    this.writeSimpleTextElement(level + 1, "unit", (String)units.get(0));
                }
                if (enumValues.size() != 0) {
                    this.newlineAndIndent(level + 2);
                    this.w.writeStartElement("enum");
                    for (i = 0; i < enumValues.size(); ++i) {
                        String label = (String)enumLabels.get(i);
                        this.newlineAndIndent(level + 3);
                        this.w.writeStartElement("value");
                        if (label != null && label.length() != 0) {
                            this.w.writeAttribute("label", label);
                        }
                        this.w.writeCharacters((String)enumValues.get(i));
                        this.w.writeEndElement();
                    }
                    this.newlineAndIndent(level + 2);
                    this.w.writeEndElement();
                }
                this.newlineAndIndent(level + 1);
                this.w.writeEndElement();
            }
        }
        if (c.isFolder()) {
            this.newlineAndIndent(level + 1);
            this.w.writeStartElement("narrower");
            this.writeConcepts(this.o.getChildren(c.key, this.includeMetadata), level + 2);
            this.newlineAndIndent(level + 1);
            this.w.writeEndElement();
        }
        this.newlineAndIndent(level);
        this.w.writeEndElement();
    }

    public static void main(String[] args) throws HiveException, XMLStreamException, FactoryConfigurationError, IOException {
        if (args.length < 3 || args.length > 4) {
            System.out.println("Usage: XMLExport i2b2_pm_service_url['|'i2b2_proxy_url] i2b2_user'@'domain['/'project] i2b2_password [parent_concept_key]");
            System.out.println("Example XMLExport http://services.i2b2.org/i2b2/services/PMService/ demo@i2b2demo demouser \\\\i2b2_REP\\i2b2\\Reports\\");
            System.exit(-1);
        }
        String i2b2_pm_service = args[0];
        String i2b2_user = args[1];
        String i2b2_pass = args[2];
        String parent_key = null;
        if (args.length == 4) {
            parent_key = args[3];
        }
        String i2b2_domain = null;
        int at = i2b2_user.indexOf(64);
        if (at == -1) {
            System.err.println("Domain must be specified with user name argument via '@'. E.g. demo@i2b2demo");
            System.exit(-1);
        }
        i2b2_domain = i2b2_user.substring(at + 1);
        i2b2_user = i2b2_user.substring(0, at);
        String i2b2_project = null;
        at = i2b2_domain.indexOf(47);
        if (at != -1) {
            i2b2_project = i2b2_domain.substring(at + 1);
            i2b2_domain = i2b2_domain.substring(0, at);
        }
        String i2b2_proxy = null;
        at = i2b2_pm_service.indexOf(124);
        if (at != -1) {
            i2b2_proxy = i2b2_pm_service.substring(at + 1);
            i2b2_pm_service = i2b2_pm_service.substring(0, at);
        }
        Li2b2Client c = Li2b2Client.initializeClient(i2b2_proxy, i2b2_pm_service, i2b2_domain, i2b2_user, i2b2_pass, i2b2_project);
        try (OutputStreamWriter out = new OutputStreamWriter(System.out);){
            XMLExport x = new XMLExport(c.ONT(), out);
            if (parent_key != null) {
                x.exportSubtree(parent_key);
            } else {
                x.exportAll();
            }
        }
    }
}

