/*
 * Decompiled with CFR 0.152.
 */
package de.sekmi.li2b2.client;

import de.sekmi.li2b2.client.MessageLogger;
import de.sekmi.li2b2.client.crc.QueryClient;
import de.sekmi.li2b2.client.ont.OntologyClient;
import de.sekmi.li2b2.client.pm.PMClient;
import de.sekmi.li2b2.client.pm.UserConfiguration;
import de.sekmi.li2b2.hive.Credentials;
import de.sekmi.li2b2.hive.DOMUtils;
import de.sekmi.li2b2.hive.HiveException;
import de.sekmi.li2b2.hive.HiveRequest;
import de.sekmi.li2b2.hive.pm.Cell;
import de.sekmi.li2b2.hive.pm.UserProject;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Li2b2Client {
    private URL proxy;
    Credentials credentials;
    private String projectId;
    private PMClient pm;
    private OntologyClient ont;
    private QueryClient crc;
    private Document requestTemplate;
    private DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
    private String outputEncoding;
    private MessageLogger messageLog;

    public Li2b2Client() {
        this.factory.setNamespaceAware(true);
        this.outputEncoding = "UTF-8";
        try {
            DocumentBuilder b = this.factory.newDocumentBuilder();
            this.requestTemplate = b.parse(this.getClass().getResourceAsStream("/request_template.xml"));
            DOMUtils.stripWhitespace((Element)this.requestTemplate.getDocumentElement());
        }
        catch (IOException | ParserConfigurationException | XPathExpressionException | SAXException e) {
            throw new RuntimeException("Unable to load resource /request_template.xml", e);
        }
        this.projectId = "undefined";
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public void setProxy(URL proxy) {
        this.proxy = proxy;
    }

    public URL getProxy() {
        return this.proxy;
    }

    public String getOutputEncoding() {
        return this.outputEncoding;
    }

    public String getUserLogin() {
        return this.credentials.getUser();
    }

    public String getUserDomain() {
        return this.credentials.getDomain();
    }

    public MessageLogger getMessageLog() {
        return this.messageLog;
    }

    public void setMessageLog(MessageLogger log) {
        this.messageLog = log;
    }

    @Deprecated
    public void setAuthorisation(String user, String password, String domain, boolean isToken) {
        this.setCredentials(new Credentials(domain, user, password, isToken));
    }

    @Deprecated
    public void setAuthorisation(String user, String password, String domain) {
        this.setAuthorisation(user, password, domain, false);
    }

    public void setCredentials(String domain, String user, String password) {
        this.setAuthorisation(user, password, domain, false);
    }

    public void setCredentials(Credentials credentials) {
        this.credentials = credentials;
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    DocumentBuilder newBuilder() {
        try {
            return this.factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public void setPM(URL pmService) {
        this.pm = new PMClient(this, pmService);
    }

    public void setONT(String uri) throws MalformedURLException {
        this.ont = new OntologyClient(this, new URL(this.pm.serviceUrl, uri));
    }

    public void setCRC(String uri) throws MalformedURLException {
        this.crc = new QueryClient(this, new URL(this.pm.serviceUrl, uri));
    }

    public PMClient PM() {
        return this.pm;
    }

    public OntologyClient ONT() {
        return this.ont;
    }

    public QueryClient CRC() {
        return this.crc;
    }

    protected HiveRequest createRequest(DocumentBuilder builder) {
        Document req = builder.newDocument();
        req.appendChild(req.importNode(this.requestTemplate.getDocumentElement(), true));
        HiveRequest r = new HiveRequest(req);
        r.setMessageId("asdf", "0");
        return r;
    }

    public void setServices(Cell[] cells) throws MalformedURLException {
        block8: for (int i = 0; i < cells.length; ++i) {
            switch (cells[i].id) {
                case "ONT": {
                    this.setONT(cells[i].url);
                    continue block8;
                }
                case "CRC": {
                    this.setCRC(cells[i].url);
                    continue block8;
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Li2b2Client initializeClient(String i2b2_proxy, String i2b2_pm_service, String i2b2_domain, String i2b2_user, String i2b2_pass, String i2b2_project) throws MalformedURLException, HiveException {
        UserConfiguration uc;
        Li2b2Client c;
        block7: {
            c = new Li2b2Client();
            if (i2b2_proxy != null) {
                c.setProxy(new URL(i2b2_proxy));
            }
            c.setPM(new URL(i2b2_pm_service));
            c.setCredentials(i2b2_domain, i2b2_user, i2b2_pass);
            uc = c.PM().requestUserConfiguration();
            if (i2b2_project == null) {
                UserProject[] projects = uc.getProjects();
                if (projects != null && projects.length == 1) {
                    c.setProjectId(projects[0].id);
                    break block7;
                } else {
                    StringBuilder b = new StringBuilder();
                    int i = 0;
                    while (true) {
                        if (i >= projects.length) {
                            throw new IllegalArgumentException("Auto project selection failed. Available projects: " + b.toString());
                        }
                        if (i != 0) {
                            b.append(", ");
                        }
                        b.append(projects[i].id);
                        ++i;
                    }
                }
            }
            c.setProjectId(i2b2_project);
        }
        c.setServices(uc.getCells());
        return c;
    }

    public Document parseXML(InputStream in) throws IOException {
        try {
            return this.newBuilder().parse(in);
        }
        catch (SAXException e) {
            throw new IOException(e);
        }
    }

    public Document parseXML(String document) throws IOException {
        try {
            return this.newBuilder().parse(new InputSource(new StringReader(document)));
        }
        catch (SAXException e) {
            throw new IOException(e);
        }
    }
}

