/*
 * Decompiled with CFR 0.152.
 */
package de.sekmi.li2b2.client;

import de.sekmi.li2b2.client.CellClient;
import de.sekmi.li2b2.client.MessageLogger;
import java.io.PrintStream;
import java.io.StringWriter;
import java.net.URL;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;

public abstract class FormattedMessageLogger
implements MessageLogger {
    private TransformerFactory factory = TransformerFactory.newInstance();

    private Transformer newTransformer() throws TransformerConfigurationException {
        Transformer transformer = this.factory.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        return transformer;
    }

    public abstract void logRequest(CellClient var1, URL var2, String var3);

    public abstract void logResponse(CellClient var1, URL var2, String var3);

    @Override
    public void logRequest(CellClient cell, URL requestUrl, Document request) {
        try {
            this.logResponse(cell, requestUrl, this.xmlToString(request));
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void logResponse(CellClient cell, URL requestUrl, Document response, Document request) {
        try {
            this.logResponse(cell, requestUrl, this.xmlToString(response));
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
    }

    private String xmlToString(Document document) throws TransformerException {
        StringWriter writer = new StringWriter();
        this.newTransformer().transform(new DOMSource(document), new StreamResult(writer));
        return writer.toString();
    }

    public static final String formatXML(Document document) throws TransformerException {
        return FormattedMessageLogger.consoleLogger().xmlToString(document);
    }

    public static final FormattedMessageLogger printLogger(final PrintStream out) {
        return new FormattedMessageLogger(){

            @Override
            public void logResponse(CellClient cell, URL requestUrl, String response) {
                out.print("Response from " + requestUrl.toString() + ":");
                out.println(response);
            }

            @Override
            public void logRequest(CellClient cell, URL requestUrl, String request) {
                out.print("Request to " + requestUrl.toString() + ":");
                out.println(request);
            }
        };
    }

    public static final FormattedMessageLogger consoleLogger() {
        return FormattedMessageLogger.printLogger(System.out);
    }
}

