/*
 * Decompiled with CFR 0.152.
 */
package de.sekmi.li2b2.client;

import de.sekmi.li2b2.client.Li2b2Client;
import de.sekmi.li2b2.client.ont.Concept;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.bind.JAXB;
import javax.xml.transform.TransformerException;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TestJAXB {
    @Test
    public void unmarshalConceptWithoutCounts() {
        Concept c = (Concept)JAXB.unmarshal((InputStream)this.getClass().getResourceAsStream("/concept_without_totalnum.xml"), Concept.class);
        Assert.assertNull((Object)c.totalnum);
        Assert.assertEquals((Object)new Integer(2), (Object)c.level);
        Assert.assertTrue((boolean)c.isFolder());
        Assert.assertEquals((Object)"\\\\i2b2_DIAG\\i2b2\\Diagnoses\\Circulatory system (390-459)\\", (Object)c.key);
        Assert.assertEquals((Object)"Circulatory system", (Object)c.name);
    }

    @Test
    public void unmarshalConceptWithMetadata() {
        Concept c = (Concept)JAXB.unmarshal((InputStream)this.getClass().getResourceAsStream("/concept_with_metadata.xml"), Concept.class);
        Assert.assertNotNull((Object)c.getMetadataXML());
        Assert.assertEquals((Object)"ValueMetadata", (Object)c.getMetadataXML().getFirstChild().getLocalName());
    }

    @Test
    public void testParseXML() throws IOException, TransformerException {
        String[] files;
        Li2b2Client client = new Li2b2Client();
        Document resultBundle = client.parseXML("<i2b2-result-bundle/>");
        Element root = resultBundle.getDocumentElement();
        Assert.assertEquals((Object)"i2b2-result-bundle", (Object)root.getLocalName());
        for (String file : files = new String[]{"result_patient_count.xml", "result_patient_age_count.xml", "result_patient_gender_count.xml"}) {
            Document b1 = client.parseXML(this.getClass().getResourceAsStream("/" + file));
            NodeList nl = b1.getElementsByTagNameNS("http://www.i2b2.org/xsd/hive/msg/result/1.1/", "result");
            Assert.assertEquals((long)1L, (long)nl.getLength());
            Element result = (Element)nl.item(0);
            root.appendChild(root.getOwnerDocument().importNode(result, true));
        }
        resultBundle.normalizeDocument();
    }
}

