/*
 * Decompiled with CFR 0.152.
 */
package de.sekmi.li2b2.client;

import de.sekmi.li2b2.client.FormattedMessageLogger;
import de.sekmi.li2b2.client.Li2b2Client;
import de.sekmi.li2b2.client.MessageLogger;
import de.sekmi.li2b2.client.ont.Concept;
import de.sekmi.li2b2.client.ont.OntologyClient;
import de.sekmi.li2b2.client.pm.Role;
import de.sekmi.li2b2.client.pm.User;
import de.sekmi.li2b2.client.pm.UserConfiguration;
import de.sekmi.li2b2.hive.ErrorResponseException;
import de.sekmi.li2b2.hive.HiveException;
import de.sekmi.li2b2.hive.pm.Param;
import de.sekmi.li2b2.hive.pm.ParamType;
import de.sekmi.li2b2.hive.pm.UserProject;
import java.io.OutputStream;
import java.net.URL;
import java.util.Arrays;
import javax.xml.bind.JAXB;
import org.junit.Assert;
import org.junit.Test;

public class TestClientUOLlocal {
    public static void main(String[] args) throws Exception {
        Li2b2Client c = new Li2b2Client();
        c.setMessageLog((MessageLogger)FormattedMessageLogger.consoleLogger());
        c.setProxy(new URL("http://134.106.36.86:8020/webclient/index.php"));
        c.setPM(new URL("http://127.0.0.1:9090/i2b2/services/PMService/"));
        c.setAuthorisation("i2b2", "demouser", "i2b2demo");
        UserConfiguration uc = c.PM().requestUserConfiguration();
        UserProject[] projects = uc.getProjects();
        if (projects != null) {
            c.setProjectId(projects[0].id);
            System.out.println("Project:" + projects[0].id);
            System.out.println("Roles:" + Arrays.toString(projects[0].role));
        }
        TestClientUOLlocal.testUserParams(c);
        c.setServices(uc.getCells());
    }

    public static void printOntology(OntologyClient ont) throws HiveException {
        Concept[] c = ont.getCategories();
        for (int i = 0; i < c.length; ++i) {
            TestClientUOLlocal.printOntologyChildren(ont, c[i], 0);
        }
    }

    private static void printOntologyChildren(OntologyClient ont, Concept concept, int level) throws HiveException {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < level; ++i) {
            b.append('\t');
        }
        if (concept.isFolder()) {
            b.append('+');
        } else {
            b.append('-');
        }
        b.append(concept.name);
        System.out.println(b.toString());
        if (concept.isFolder()) {
            Concept[] c = ont.getChildren(concept.key);
            for (int i = 0; i < c.length; ++i) {
                TestClientUOLlocal.printOntologyChildren(ont, c[i], level + 1);
            }
        }
    }

    public static void testUserParams(Li2b2Client c) throws ErrorResponseException, HiveException {
        String PARAM_NAME = "li2b2TEST";
        c.PM().addUserParam("demo", ParamType.Text.getCode(), "li2b2TEST", "123");
        Param[] params = c.PM().getUserParams("demo");
        System.out.println("Params: " + params.length);
        int count = params.length;
        for (int i = 0; i < params.length; ++i) {
            System.out.println("Param[" + params[i].id + "]=(" + params[i].datatype + ", name=" + params[i].name + ", value=" + params[i].value + ")");
            if (!params[i].name.equals("li2b2TEST")) continue;
            c.PM().deleteUserParam(params[i].id.intValue());
        }
        params = c.PM().getUserParams("demo");
        Assert.assertEquals((long)(count - 1), (long)params.length);
    }

    public static void testProjectParams(Li2b2Client c) throws ErrorResponseException, HiveException {
        String PARAM_NAME = "li2b2TEST";
        c.PM().addProjectParam("Demo", ParamType.Text.getCode(), "li2b2TEST", "123");
        Param[] params = c.PM().getProjectParams("Demo");
        System.out.println("Params: " + params.length);
        int count = params.length;
        for (int i = 0; i < params.length; ++i) {
            System.out.println("Param[" + params[i].id + "]=(" + params[i].datatype + ", name=" + params[i].name + ", value=" + params[i].value + ")");
            if (!params[i].name.equals("li2b2TEST")) continue;
            c.PM().deleteProjectParam(params[i].id.intValue());
        }
        params = c.PM().getProjectParams("Demo");
        Assert.assertEquals((long)(count - 1), (long)params.length);
    }

    public static void testHiveParams(Li2b2Client c) throws ErrorResponseException, HiveException {
        String PARAM_NAME = "li2b2TEST";
        c.PM().addHiveParam(ParamType.Text.getCode(), "li2b2TEST", "123");
        Param[] params = c.PM().getHiveParams("/");
        System.out.println("Params: " + params.length);
        int count = params.length;
        for (int i = 0; i < params.length; ++i) {
            System.out.println("Param[" + params[i].id + "]=(" + params[i].datatype + ", name=" + params[i].name + ", value=" + params[i].value + ")");
            if (!params[i].name.equals("li2b2TEST")) continue;
            c.PM().deleteHiveParam(params[i].id.intValue());
        }
        params = c.PM().getHiveParams("/");
        Assert.assertEquals((long)(count - 1), (long)params.length);
    }

    public static void testRoles(Li2b2Client c) throws HiveException {
        Role[] roles = c.PM().getRoles();
        c.PM().getRoles("i2b2", "Demo");
        for (Role r : roles = c.PM().getRoles("Demo")) {
            System.out.println(r.toString());
        }
        try {
            c.PM().setRole("demo", "Aktin_test", "Demo");
            c.PM().setRole("demo2", "Aktin_test2", "Demo");
            c.PM().setRole("@", "Aktin_test3", "Demo");
        }
        catch (ErrorResponseException e) {
            System.err.println(e.getMessage());
        }
        for (Role r : roles = c.PM().getRoles("Demo")) {
            System.out.println(r.toString());
        }
        try {
            c.PM().deleteRole("demo", "Aktin_test", "Demo");
            c.PM().deleteRole("demo2", "Aktin_test2", "Demo");
            c.PM().deleteRole("@", "Aktin_test3", "Demo");
        }
        catch (ErrorResponseException e) {
            System.err.println(e.getMessage());
        }
        try {
            c.PM().deleteRole("demo", "Aktin_test2", "Demo");
        }
        catch (ErrorResponseException e) {
            System.err.println(e.getMessage());
        }
        for (Role r : roles = c.PM().getRoles("Demo")) {
            System.out.println(r.toString());
        }
    }

    public static void testUsers(Li2b2Client c) throws HiveException {
        User[] users;
        User singleUser = c.PM().getUser("demo");
        System.out.println(singleUser.toString());
        for (User u : users = c.PM().getUsers()) {
            System.out.println(u.toString());
        }
        c.setMessageLog((MessageLogger)FormattedMessageLogger.consoleLogger());
        c.PM().setUser("test1", null, null, "asdf", false);
        for (User u : users = c.PM().getUsers()) {
            System.out.println(u.toString());
        }
        c.PM().setUser("test1", "test user 1", "test@aktin.org", "asdf", false);
        for (User u : users = c.PM().getUsers()) {
            System.out.println(u.toString());
        }
        c.PM().deleteUser("test1");
        for (User u : users = c.PM().getUsers()) {
            System.out.println(u.toString());
        }
        c.PM().deleteUser("test1");
        try {
            c.PM().deleteUser("neverthere");
            Assert.fail((String)"Deleting non-existend user should fail");
        }
        catch (ErrorResponseException e) {
            Assert.assertEquals((Object)"User not updated, does it exist?", (Object)e.getHiveMessage());
        }
    }

    @Test
    public void outPutRole() {
        Role testRole = new Role("Demo", "demo", "User");
        JAXB.marshal((Object)testRole, (OutputStream)System.out);
    }

    @Test
    public void outPutUser() {
        User testUser = new User();
        testUser.user_name = "demo";
        testUser.full_name = "demo user";
        testUser.email = "demo@aktin.org";
        testUser.is_admin = false;
        JAXB.marshal((Object)testUser, (OutputStream)System.out);
        testUser.password = "halsdkjlqwejliqhweli";
        JAXB.marshal((Object)testUser, (OutputStream)System.out);
    }
}

