/*
 * Decompiled with CFR 0.152.
 */
package de.sekmi.li2b2.client.pm;

import de.sekmi.li2b2.hive.HiveException;
import de.sekmi.li2b2.hive.pm.Cell;
import de.sekmi.li2b2.hive.pm.UserProject;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class UserConfiguration {
    private boolean isAdmin;
    private String fullName;
    private String sessionKey;
    private String userName;
    private String userDomain;
    UserProject[] projects;
    Cell[] cells;

    public String getSessionKey() {
        return this.sessionKey;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getUserDomain() {
        return this.userDomain;
    }

    public boolean isAdmin() {
        return this.isAdmin;
    }

    public String getUserFullName() {
        return this.fullName;
    }

    private void parseElement(Element configure) throws HiveException {
        Element user = (Element)configure.getElementsByTagName("user").item(0);
        this.fullName = user.getElementsByTagName("full_name").item(0).getTextContent();
        this.userName = user.getElementsByTagName("user_name").item(0).getTextContent();
        this.userDomain = user.getElementsByTagName("domain").item(0).getTextContent();
        this.sessionKey = user.getElementsByTagName("password").item(0).getTextContent();
        this.isAdmin = Boolean.parseBoolean(user.getElementsByTagName("is_admin").item(0).getTextContent());
        try {
            int i;
            Unmarshaller um = JAXBContext.newInstance((Class[])new Class[]{Cell.class, UserProject.class}).createUnmarshaller();
            NodeList nl = user.getElementsByTagName("project");
            this.projects = new UserProject[nl.getLength()];
            for (i = 0; i < this.projects.length; ++i) {
                this.projects[i] = (UserProject)um.unmarshal((Source)new DOMSource(nl.item(i)));
            }
            nl = configure.getElementsByTagName("cell_data");
            this.cells = new Cell[nl.getLength()];
            for (i = 0; i < this.cells.length; ++i) {
                this.cells[i] = (Cell)um.unmarshal((Source)new DOMSource(nl.item(i)));
            }
        }
        catch (JAXBException e) {
            throw new HiveException("error parsing concepts", (Throwable)e);
        }
    }

    public static UserConfiguration parse(Element configure) throws HiveException {
        UserConfiguration ci = new UserConfiguration();
        ci.parseElement(configure);
        return ci;
    }

    public UserProject[] getProjects() {
        return this.projects;
    }

    public Cell[] getCells() {
        return this.cells;
    }
}

