/*
 * Decompiled with CFR 0.152.
 */
package de.sekmi.li2b2.client.ont;

import de.sekmi.li2b2.client.CellClient;
import de.sekmi.li2b2.client.Li2b2Client;
import de.sekmi.li2b2.client.ont.Concept;
import de.sekmi.li2b2.hive.HiveException;
import de.sekmi.li2b2.hive.HiveRequest;
import java.net.URL;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class OntologyClient
extends CellClient {
    public static final String XMLNS = "http://www.i2b2.org/xsd/cell/ont/1.1/";

    public OntologyClient(Li2b2Client client, URL serviceUrl) {
        super(client, serviceUrl);
    }

    public Concept[] getCategories() throws HiveException {
        HiveRequest req = this.createRequestMessage();
        Element el = req.addBodyElement(XMLNS, "get_categories");
        el.setAttribute("synonyms", "true");
        el.setAttribute("hiddens", "false");
        el.setAttribute("type", "core");
        el = this.submitRequestWithResponseContent(req, "getCategories", XMLNS, "concepts");
        return this.parseConcepts(el);
    }

    public Concept[] getSchemes() throws HiveException {
        HiveRequest req = this.createRequestMessage();
        Element el = req.addBodyElement(XMLNS, "get_schemes");
        el.setAttribute("type", "default");
        el = this.submitRequestWithResponseContent(req, "getSchemes", XMLNS, "concepts");
        return this.parseConcepts(el);
    }

    public Concept[] getChildren(String parentKey) throws HiveException {
        HiveRequest req = this.createRequestMessage();
        Element el = req.addBodyElement(XMLNS, "get_children");
        el.setPrefix("ns4");
        el.setAttribute("blob", "false");
        el.setAttribute("type", "core");
        el.setAttribute("synonyms", "false");
        el.setAttribute("hiddens", "false");
        this.appendTextElement(el, "parent", parentKey);
        el = this.submitRequestWithResponseContent(req, "getChildren", XMLNS, "concepts");
        return this.parseConcepts(el);
    }

    private Concept[] parseConcepts(Element conceptWrapper) throws HiveException {
        NodeList nl = conceptWrapper.getChildNodes();
        Concept[] concepts = new Concept[nl.getLength()];
        try {
            Unmarshaller um = JAXBContext.newInstance((Class[])new Class[]{Concept.class}).createUnmarshaller();
            for (int i = 0; i < concepts.length; ++i) {
                concepts[i] = (Concept)um.unmarshal((Source)new DOMSource(nl.item(i)));
            }
        }
        catch (JAXBException e) {
            throw new HiveException("error parsing concepts", (Throwable)e);
        }
        return concepts;
    }
}

