/*
 * Decompiled with CFR 0.152.
 */
package de.sekmi.li2b2.client;

import de.sekmi.li2b2.client.Li2b2Client;
import de.sekmi.li2b2.hive.DOMUtils;
import de.sekmi.li2b2.hive.ErrorResponseException;
import de.sekmi.li2b2.hive.HiveException;
import de.sekmi.li2b2.hive.HiveRequest;
import de.sekmi.li2b2.hive.HiveResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Objects;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class CellClient {
    protected Li2b2Client client;
    protected URL serviceUrl;

    public CellClient(Li2b2Client client, URL serviceUrl) {
        this.client = client;
        this.serviceUrl = serviceUrl;
    }

    public URL getServiceURL() {
        return this.serviceUrl;
    }

    protected String getOutputCharset() {
        return this.client.getOutputEncoding();
    }

    protected URL createRequest(String path) throws MalformedURLException {
        return new URL(this.getServiceURL(), path);
    }

    protected DocumentBuilder newBuilder() {
        return this.client.newBuilder();
    }

    protected HiveRequest createRequestMessage(DocumentBuilder builder) {
        HiveRequest req = this.client.createRequest(builder);
        req.setTimestamp();
        req.setSecurity(this.client.credentials);
        req.setProjectId(this.client.getProjectId());
        return req;
    }

    protected HiveRequest createRequestMessage() {
        return this.createRequestMessage(this.newBuilder());
    }

    protected HiveRequest createRequestMessage(String bodyXML) throws SAXException, IOException {
        DocumentBuilder b = this.newBuilder();
        HiveRequest req = this.createRequestMessage(b);
        Document dom = b.parse(new InputSource(new StringReader(bodyXML)));
        Element body = req.getMessageBody();
        Objects.requireNonNull(body, "no message_body");
        body.appendChild(body.getOwnerDocument().adoptNode(dom.getDocumentElement()));
        return req;
    }

    protected HttpURLConnection createConnection(HiveRequest HiveRequest2, URL requestUrl) throws IOException {
        HttpURLConnection c;
        if (this.client.getProxy() != null) {
            HiveRequest2.setRedirectUrl(requestUrl);
            c = (HttpURLConnection)this.client.getProxy().openConnection();
        } else {
            HiveRequest2.setRedirectUrl(null);
            c = (HttpURLConnection)requestUrl.openConnection();
        }
        c.setRequestMethod("POST");
        c.setDoOutput(true);
        c.setRequestProperty("Content-Type", "application/xml; charset=" + this.getOutputCharset());
        return c;
    }

    protected HiveResponse submitRequest(HiveRequest HiveRequest2, String method) throws HiveException {
        try {
            return this.submitRequest(this.newBuilder(), HiveRequest2, this.createRequest(method));
        }
        catch (MalformedURLException e) {
            throw new HiveException("RESTful endpoint URL construction failed: " + method, (Throwable)e);
        }
    }

    protected HiveResponse submitRequest(DocumentBuilder b, HiveRequest request, URL requestUrl) throws HiveException {
        Document resp;
        HttpURLConnection c;
        try {
            c = this.createConnection(request, requestUrl);
            c.connect();
        }
        catch (IOException e) {
            throw new HiveException((Throwable)e);
        }
        try (OutputStream out = c.getOutputStream();){
            if (this.client.getMessageLog() != null) {
                this.client.getMessageLog().logRequest(this, requestUrl, request.getDOM());
            }
            DOMUtils.printDOM((Node)request.getDOM(), (OutputStream)out, (String)this.getOutputCharset());
        }
        catch (TransformerException e) {
            throw new HiveException("DOM compilation failed", (Throwable)e);
        }
        catch (IOException e) {
            throw new HiveException("Unable to write to URL connection", (Throwable)e);
        }
        try (InputStream in = c.getInputStream();){
            resp = b.parse(in);
            DOMUtils.stripWhitespace((Element)resp.getDocumentElement());
        }
        catch (IOException | XPathExpressionException | SAXException e) {
            throw new HiveException("Unable to parse HiveResponse", (Throwable)e);
        }
        if (this.client.getMessageLog() != null) {
            this.client.getMessageLog().logResponse(this, requestUrl, resp, request.getDOM());
        }
        return new HiveResponse(resp);
    }

    protected Element submitRequestWithResponseContent(HiveRequest HiveRequest2, String restMethod, String responseNS, String responseElement) throws HiveException {
        HiveResponse resp = this.submitRequest(HiveRequest2, restMethod);
        HiveResponse.ResultStatus rs = resp.getResultStatus();
        if (!rs.getCode().equals("DONE")) {
            throw new ErrorResponseException(rs);
        }
        return resp.requireBodyElement(responseNS, responseElement);
    }

    protected Element appendTextElement(Element parent, String name, String value) {
        Element e = parent.getOwnerDocument().createElement(name);
        parent.appendChild(e).setTextContent(value);
        return e;
    }

    protected Element appendOptionalElement(Element parent, String name, String value) {
        if (value == null) {
            return null;
        }
        return this.appendTextElement(parent, name, value);
    }
}

