/*
 * Decompiled with CFR 0.152.
 */
package de.sekmi.li2b2.client;

import de.sekmi.li2b2.client.FormattedMessageLogger;
import de.sekmi.li2b2.client.Li2b2Client;
import de.sekmi.li2b2.client.ont.Concept;
import de.sekmi.li2b2.client.ont.OntologyClient;
import de.sekmi.li2b2.client.ont.XMLExport;
import de.sekmi.li2b2.client.pm.Role;
import de.sekmi.li2b2.client.pm.User;
import de.sekmi.li2b2.client.pm.UserConfiguration;
import de.sekmi.li2b2.hive.ErrorResponseException;
import de.sekmi.li2b2.hive.HiveException;
import de.sekmi.li2b2.hive.pm.UserProject;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Arrays;
import javax.xml.bind.JAXB;
import org.junit.Assert;
import org.junit.Test;

public class TestClientUOLlocal {
    public static void main(String[] args) throws Exception {
        Li2b2Client c = new Li2b2Client();
        c.setProxy(new URL("http://localhost/webclient/index.php"));
        c.setPM(new URL("http://127.0.0.1:9090/i2b2/services/PMService/"));
        c.setAuthorisation("i2b2", "demouser", "i2b2demo");
        UserConfiguration uc = c.PM().requestUserConfiguration();
        UserProject[] projects = uc.getProjects();
        if (projects != null) {
            c.setProjectId(projects[0].id);
            System.out.println("Project:" + projects[0].id);
            System.out.println("Roles:" + Arrays.toString(projects[0].role));
        }
        c.setServices(uc.getCells());
        XMLExport x = new XMLExport(c.ONT(), (Writer)new OutputStreamWriter(System.out));
        x.exportAll();
    }

    public static void printOntology(OntologyClient ont) throws HiveException {
        Concept[] c = ont.getCategories();
        for (int i = 0; i < c.length; ++i) {
            TestClientUOLlocal.printOntologyChildren(ont, c[i], 0);
        }
    }

    private static void printOntologyChildren(OntologyClient ont, Concept concept, int level) throws HiveException {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < level; ++i) {
            b.append('\t');
        }
        if (concept.isFolder()) {
            b.append('+');
        } else {
            b.append('-');
        }
        b.append(concept.name);
        System.out.println(b.toString());
        if (concept.isFolder()) {
            Concept[] c = ont.getChildren(concept.key);
            for (int i = 0; i < c.length; ++i) {
                TestClientUOLlocal.printOntologyChildren(ont, c[i], level + 1);
            }
        }
    }

    public static void testRoles(Li2b2Client c) throws HiveException {
        Role[] roles = c.PM().getRoles();
        c.PM().getRoles("i2b2", "Demo");
        for (Role r : roles = c.PM().getRoles("Demo")) {
            System.out.println(r.toString());
        }
        try {
            c.PM().setRole("demo", "Aktin_test", "Demo");
            c.PM().setRole("demo2", "Aktin_test2", "Demo");
            c.PM().setRole("@", "Aktin_test3", "Demo");
        }
        catch (ErrorResponseException e) {
            System.err.println(e.getMessage());
        }
        for (Role r : roles = c.PM().getRoles("Demo")) {
            System.out.println(r.toString());
        }
        try {
            c.PM().deleteRole("demo", "Aktin_test", "Demo");
            c.PM().deleteRole("demo2", "Aktin_test2", "Demo");
            c.PM().deleteRole("@", "Aktin_test3", "Demo");
        }
        catch (ErrorResponseException e) {
            System.err.println(e.getMessage());
        }
        try {
            c.PM().deleteRole("demo", "Aktin_test2", "Demo");
        }
        catch (ErrorResponseException e) {
            System.err.println(e.getMessage());
        }
        for (Role r : roles = c.PM().getRoles("Demo")) {
            System.out.println(r.toString());
        }
    }

    public static void testUsers(Li2b2Client c) throws HiveException {
        User[] users;
        User singleUser = c.PM().getUser("demo");
        System.out.println(singleUser.toString());
        for (User u : users = c.PM().getUsers()) {
            System.out.println(u.toString());
        }
        c.setMessageLog(FormattedMessageLogger.consoleLogger());
        c.PM().setUser("test1", null, null, "asdf", false);
        for (User u : users = c.PM().getUsers()) {
            System.out.println(u.toString());
        }
        c.PM().setUser("test1", "test user 1", "test@aktin.org", "asdf", false);
        for (User u : users = c.PM().getUsers()) {
            System.out.println(u.toString());
        }
        c.PM().deleteUser("test1");
        for (User u : users = c.PM().getUsers()) {
            System.out.println(u.toString());
        }
        c.PM().deleteUser("test1");
        try {
            c.PM().deleteUser("neverthere");
            Assert.fail((String)"Deleting non-existend user should fail");
        }
        catch (ErrorResponseException e) {
            Assert.assertEquals((Object)"User not updated, does it exist?", (Object)e.getHiveMessage());
        }
    }

    @Test
    public void outPutRole() {
        Role testRole = new Role("Demo", "demo", "User");
        JAXB.marshal((Object)testRole, (OutputStream)System.out);
    }

    @Test
    public void outPutUser() {
        User testUser = new User();
        testUser.user_name = "demo";
        testUser.full_name = "demo user";
        testUser.email = "demo@aktin.org";
        testUser.is_admin = false;
        JAXB.marshal((Object)testUser, (OutputStream)System.out);
        testUser.password = "halsdkjlqwejliqhweli";
        JAXB.marshal((Object)testUser, (OutputStream)System.out);
    }
}

