/*
 * Decompiled with CFR 0.152.
 */
package de.sekmi.li2b2.client.pm;

import de.sekmi.li2b2.hive.HiveException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

@XmlRootElement(name="user")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class User {
    public String full_name;
    public String user_name;
    public String email;
    public String password;
    public boolean is_admin;

    private void parseUserElement(Element element) {
        if (element.getElementsByTagName("full_name").getLength() > 0) {
            this.full_name = element.getElementsByTagName("full_name").item(0).getTextContent();
        }
        if (element.getElementsByTagName("user_name").getLength() > 0) {
            this.user_name = element.getElementsByTagName("user_name").item(0).getTextContent();
        }
        if (element.getElementsByTagName("email").getLength() > 0) {
            this.email = element.getElementsByTagName("email").item(0).getTextContent();
        }
        if (element.getElementsByTagName("password").getLength() > 0) {
            this.password = element.getElementsByTagName("password").item(0).getTextContent();
        }
        if (element.getElementsByTagName("is_admin").getLength() > 0) {
            this.is_admin = element.getElementsByTagName("is_admin").item(0).getTextContent() == "true";
        }
    }

    public static User parseUser(Element userElement) throws HiveException {
        User user = new User();
        System.out.println(userElement.getTagName() + userElement.getElementsByTagName("email").getLength());
        user.parseUserElement(userElement);
        return user;
    }

    public static User[] parse(Element usersElement) throws HiveException {
        NodeList userNodes = usersElement.getChildNodes();
        User[] users = new User[userNodes.getLength()];
        try {
            Unmarshaller um = JAXBContext.newInstance((Class[])new Class[]{User.class}).createUnmarshaller();
            for (int i = 0; i < users.length; ++i) {
                Element user = (Element)userNodes.item(i);
                users[i] = (User)um.unmarshal((Source)new DOMSource(user));
            }
        }
        catch (JAXBException e) {
            throw new HiveException("error parsing users", (Throwable)e);
        }
        return users;
    }

    public String toString() {
        return this.full_name + " as " + this.user_name + ", email: " + this.email + ", " + (this.is_admin ? "is a admin." : "no admin") + " pw: " + this.password;
    }
}

