/*
 * Decompiled with CFR 0.152.
 */
package de.sekmi.li2b2.client.crc;

import de.sekmi.li2b2.client.crc.CRCException;
import de.sekmi.li2b2.hive.HiveException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ResponseBody {
    private static final Logger log = Logger.getLogger(ResponseBody.class.getName());
    private Element el;

    public ResponseBody(Element element) {
        this.el = element;
    }

    public Element getStatusCondition() throws HiveException {
        if (!this.el.getFirstChild().getNodeName().equals("status")) {
            throw new HiveException("status not found in response");
        }
        Node n = this.el.getFirstChild().getFirstChild();
        if (n.getNodeType() != 1) {
            throw new HiveException("Status element condition not found");
        }
        return (Element)n;
    }

    public void requireConditionDone() throws HiveException, CRCException {
        Element c = this.getStatusCondition();
        if (!c.getAttribute("type").equals("DONE")) {
            throw new CRCException(c.getTextContent());
        }
    }

    public <T> List<T> unmarshalBodyElements(Class<T> type, String elementName) throws HiveException {
        NodeList nl = this.el.getChildNodes();
        log.fine("Looking for " + elementName + " in " + nl.getLength() + " elements");
        ArrayList<Object> list = new ArrayList<Object>(nl.getLength() - 1);
        try {
            Unmarshaller um = JAXBContext.newInstance((Class[])new Class[]{type}).createUnmarshaller();
            for (int i = 1; i < nl.getLength(); ++i) {
                Node n = nl.item(i);
                if (n.getNodeType() != 1 || !n.getNodeName().equals(elementName)) continue;
                list.add(um.unmarshal(n));
            }
        }
        catch (JAXBException e) {
            throw new HiveException("Unable to unmarshall list of " + type.getName());
        }
        return list;
    }

    public Element getElement() {
        return this.el;
    }
}

