/*
 * Decompiled with CFR 0.152.
 */
package de.sekmi.li2b2.client.crc;

import de.sekmi.li2b2.client.CellClient;
import de.sekmi.li2b2.client.Li2b2Client;
import de.sekmi.li2b2.client.crc.MasterInstanceResult;
import de.sekmi.li2b2.client.crc.QueryInstance;
import de.sekmi.li2b2.client.crc.QueryResultInstance;
import de.sekmi.li2b2.client.crc.ResponseBody;
import de.sekmi.li2b2.hive.HiveException;
import de.sekmi.li2b2.hive.HiveRequest;
import de.sekmi.li2b2.hive.crc.QueryMaster;
import de.sekmi.li2b2.hive.crc.QueryResultType;
import java.net.URL;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class QueryClient
extends CellClient {
    public static final String PSM_NS = "http://www.i2b2.org/xsd/cell/crc/psm/1.1/";

    public QueryClient(Li2b2Client client, URL serviceUrl) {
        super(client, serviceUrl);
    }

    private void setPSMHeader(HiveRequest request, String requestType) {
        Element el = request.addBodyElement(PSM_NS, "psmheader");
        el.setPrefix("ns4");
        Element user = el.getOwnerDocument().createElement("user");
        user.setAttribute("login", this.client.getUserLogin());
        user.setTextContent(this.client.getUserLogin());
        el.appendChild(user);
        this.appendTextElement(el, "patient_set_limit", "0");
        this.appendTextElement(el, "estimated_time", "0");
        this.appendTextElement(el, "request_type", requestType);
    }

    private Element addRequestBody(HiveRequest request, String xsiType) {
        Element el = request.addBodyElement(PSM_NS, "request");
        el.setPrefix("ns4");
        el.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:type", "ns4:" + xsiType);
        return el;
    }

    public List<QueryResultType> getResultType() throws HiveException {
        HiveRequest req = this.createPSMRequest("CRC_QRY_getResultType");
        ResponseBody rb = this.submitRequestWithResponseContent(req);
        return rb.unmarshalBodyElements(QueryResultType.class, "query_result_type");
    }

    private HiveRequest createPSMRequest(String psmRequestType) {
        HiveRequest req = this.createRequestMessage();
        this.setPSMHeader(req, psmRequestType);
        return req;
    }

    private ResponseBody submitRequestWithResponseContent(HiveRequest req) throws HiveException {
        Element el = this.submitRequestWithResponseContent(req, "request", PSM_NS, "response");
        ResponseBody rb = new ResponseBody(el);
        rb.requireConditionDone();
        return rb;
    }

    public MasterInstanceResult runQueryInstance(Element query_definition, String[] result_output_list) throws HiveException {
        HiveRequest req = this.createPSMRequest("CRC_QRY_runQueryInstance_fromQueryDefinition");
        Element el = this.addRequestBody(req, "query_definition_requestType");
        el.appendChild(el.getOwnerDocument().importNode(query_definition, true));
        Element rol = el.getOwnerDocument().createElement("result_output_list");
        el.appendChild(rol);
        for (int i = 0; i < result_output_list.length; ++i) {
            el = rol.getOwnerDocument().createElement("result_output");
            el.setAttribute("priority_index", Integer.toString(9 + i));
            el.setAttribute("name", result_output_list[i]);
            rol.appendChild(el);
        }
        ResponseBody rb = this.submitRequestWithResponseContent(req);
        try {
            Unmarshaller um = JAXBContext.newInstance((Class[])new Class[]{MasterInstanceResult.class}).createUnmarshaller();
            return (MasterInstanceResult)um.unmarshal((Node)rb.getElement(), MasterInstanceResult.class).getValue();
        }
        catch (JAXBException e) {
            throw new HiveException("Unable to unmarshal MasterInstanceResult", (Throwable)e);
        }
    }

    public List<QueryMaster> getQueryMasterList(String userId, String groupId, int fetchSize) throws HiveException {
        HiveRequest req = this.createPSMRequest("CRC_QRY_getQueryMasterList_fromUserId");
        Element el = this.addRequestBody(req, "user_requestType");
        this.appendTextElement(el, "user_id", userId);
        this.appendTextElement(el, "group_id", groupId);
        this.appendTextElement(el, "fetch_size", Integer.toString(fetchSize));
        ResponseBody rb = this.submitRequestWithResponseContent(req);
        return rb.unmarshalBodyElements(QueryMaster.class, "query_master");
    }

    public List<QueryMaster> getQueryMasterList() throws HiveException {
        return this.getQueryMasterList(this.client.getUserLogin(), this.client.getProjectId(), 20);
    }

    public List<QueryInstance> getQueryInstanceList(String masterId) throws HiveException {
        HiveRequest req = this.createPSMRequest("CRC_QRY_getQueryInstanceList_fromQueryMasterId");
        Element el = this.addRequestBody(req, "master_requestType");
        this.appendTextElement(el, "query_master_id", masterId);
        ResponseBody rb = this.submitRequestWithResponseContent(req);
        return rb.unmarshalBodyElements(QueryInstance.class, "query_instance");
    }

    public List<QueryResultInstance> getQueryResultInstanceList(String instanceId) throws HiveException {
        HiveRequest req = this.createPSMRequest("CRC_QRY_getQueryResultInstanceList_fromQueryInstanceId");
        Element el = this.addRequestBody(req, "instance_requestType");
        this.appendTextElement(el, "query_instance_id", instanceId);
        return this.submitRequestWithResponseContent(req).unmarshalBodyElements(QueryResultInstance.class, "query_result_instance");
    }

    public void deleteQueryMaster(String masterId) throws HiveException {
        HiveRequest req = this.createPSMRequest("CRC_QRY_deleteQueryMaster");
        Element el = this.addRequestBody(req, "master_delete_requestType");
        this.appendTextElement(el, "user_id", this.client.getUserLogin());
        this.appendTextElement(el, "query_master_id", masterId);
        this.submitRequestWithResponseContent(req);
    }

    public String getResultDocument(String query_result_instance_id) throws HiveException {
        HiveRequest req = this.createPSMRequest("CRC_QRY_getResultDocument_fromResultInstanceId");
        Element el = this.addRequestBody(req, "result_requestType");
        this.appendTextElement(el, "query_result_instance_id", query_result_instance_id);
        ResponseBody rb = this.submitRequestWithResponseContent(req);
        Node n = rb.getElement().getLastChild();
        if (n.getNodeType() != 1 || !n.getNodeName().equals("crc_xml_result")) {
            throw new HiveException("Expected crc_xml_result as last child of response element, but found " + n.getNodeName());
        }
        el = (Element)n;
        return el.getLastChild().getTextContent();
    }
}

