/*
 * Decompiled with CFR 0.152.
 */
package de.sekmi.li2b2.client;

import de.sekmi.li2b2.client.MessageLogger;
import de.sekmi.li2b2.client.crc.QueryClient;
import de.sekmi.li2b2.client.ont.OntologyClient;
import de.sekmi.li2b2.client.pm.PMClient;
import de.sekmi.li2b2.hive.Credentials;
import de.sekmi.li2b2.hive.DOMUtils;
import de.sekmi.li2b2.hive.HiveRequest;
import de.sekmi.li2b2.hive.pm.Cell;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class Li2b2Client {
    private URL proxy;
    Credentials credentials;
    private String projectId;
    private PMClient pm;
    private OntologyClient ont;
    private QueryClient crc;
    private Document requestTemplate;
    private DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
    private String outputEncoding;
    private MessageLogger messageLog;

    public Li2b2Client() {
        this.factory.setNamespaceAware(true);
        this.outputEncoding = "UTF-8";
        try {
            DocumentBuilder b = this.factory.newDocumentBuilder();
            this.requestTemplate = b.parse(this.getClass().getResourceAsStream("/request_template.xml"));
            DOMUtils.stripWhitespace((Element)this.requestTemplate.getDocumentElement());
        }
        catch (IOException | ParserConfigurationException | XPathExpressionException | SAXException e) {
            throw new RuntimeException("Unable to load resource /request_template.xml", e);
        }
        this.projectId = "undefined";
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public void setProxy(URL proxy) {
        this.proxy = proxy;
    }

    public URL getProxy() {
        return this.proxy;
    }

    public String getOutputEncoding() {
        return this.outputEncoding;
    }

    public String getUserLogin() {
        return this.credentials.getUser();
    }

    public String getUserDomain() {
        return this.credentials.getDomain();
    }

    public MessageLogger getMessageLog() {
        return this.messageLog;
    }

    public void setMessageLog(MessageLogger log) {
        this.messageLog = log;
    }

    public void setAuthorisation(String user, String password, String domain, boolean isToken) {
        this.setAuthorisation(new Credentials(domain, user, password, isToken));
    }

    public void setAuthorisation(String user, String password, String domain) {
        this.setAuthorisation(user, password, domain, false);
    }

    public void setAuthorisation(Credentials credentials) {
        this.credentials = credentials;
    }

    DocumentBuilder newBuilder() {
        try {
            return this.factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public void setPM(URL pmService) {
        this.pm = new PMClient(this, pmService);
    }

    public void setONT(String uri) throws MalformedURLException {
        this.ont = new OntologyClient(this, new URL(this.pm.serviceUrl, uri));
    }

    public void setCRC(String uri) throws MalformedURLException {
        this.crc = new QueryClient(this, new URL(this.pm.serviceUrl, uri));
    }

    public PMClient PM() {
        return this.pm;
    }

    public OntologyClient ONT() {
        return this.ont;
    }

    public QueryClient CRC() {
        return this.crc;
    }

    protected HiveRequest createRequest(DocumentBuilder builder) {
        Document req = builder.newDocument();
        req.appendChild(req.importNode(this.requestTemplate.getDocumentElement(), true));
        HiveRequest r = new HiveRequest(req);
        r.setMessageId("asdf", "0");
        return r;
    }

    public void setServices(Cell[] cells) throws MalformedURLException {
        block8: for (int i = 0; i < cells.length; ++i) {
            switch (cells[i].id) {
                case "ONT": {
                    this.setONT(cells[i].url);
                    continue block8;
                }
                case "CRC": {
                    this.setCRC(cells[i].url);
                    continue block8;
                }
            }
        }
    }

    public Document parseXML(InputStream in) throws IOException {
        try {
            return this.factory.newDocumentBuilder().parse(in);
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new IOException(e);
        }
    }
}

