/*
 * Decompiled with CFR 0.152.
 */
package de.sekmi.li2b2.client;

import de.sekmi.li2b2.client.CellClient;
import de.sekmi.li2b2.client.MessageLogger;
import java.io.PrintStream;
import java.io.StringWriter;
import java.net.URL;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;

public abstract class FormattedMessageLogger
implements MessageLogger {
    private TransformerFactory factory = TransformerFactory.newInstance();

    private Transformer newTransformer() throws TransformerConfigurationException {
        Transformer transformer = this.factory.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        return transformer;
    }

    public abstract void logRequest(CellClient var1, URL var2, String var3);

    public abstract void logResponse(CellClient var1, URL var2, String var3);

    @Override
    public void logRequest(CellClient cell, URL requestUrl, Document request) {
        StringWriter writer = new StringWriter();
        try {
            this.newTransformer().transform(new DOMSource(request), new StreamResult(writer));
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        this.logRequest(cell, requestUrl, writer.toString());
    }

    @Override
    public void logResponse(CellClient cell, URL requestUrl, Document response, Document request) {
        StringWriter writer = new StringWriter();
        try {
            this.newTransformer().transform(new DOMSource(response), new StreamResult(writer));
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        this.logResponse(cell, requestUrl, writer.toString());
    }

    public static final MessageLogger printLogger(final PrintStream out) {
        return new FormattedMessageLogger(){

            @Override
            public void logResponse(CellClient cell, URL requestUrl, String response) {
                out.print("Response from " + requestUrl.toString() + ":");
                out.println(response);
            }

            @Override
            public void logRequest(CellClient cell, URL requestUrl, String request) {
                out.print("Request to " + requestUrl.toString() + ":");
                out.println(request);
            }
        };
    }

    public static final MessageLogger consoleLogger() {
        return FormattedMessageLogger.printLogger(System.out);
    }
}

