/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.testsupport;

import de.learnlib.algorithm.LearningAlgorithm;
import de.learnlib.driver.simulator.MealySimulatorSUL;
import de.learnlib.query.DefaultQuery;
import de.learnlib.sul.SUL;
import de.learnlib.testsupport.example.mealy.ExampleCoffeeMachine;
import java.util.Collection;
import java.util.function.BiFunction;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.automaton.UniversalDeterministicAutomaton;
import net.automatalib.automaton.transducer.MealyMachine;
import net.automatalib.automaton.transducer.impl.CompactMealy;
import net.automatalib.util.automaton.Automata;
import net.automatalib.word.Word;

public final class VisualizationUtils {
    private VisualizationUtils() {
    }

    public static <L extends LearningAlgorithm<? extends MealyMachine<?, ExampleCoffeeMachine.Input, ?, String>, ExampleCoffeeMachine.Input, Word<String>>> L runExperiment(BiFunction<Alphabet<ExampleCoffeeMachine.Input>, SUL<ExampleCoffeeMachine.Input, String>, L> builder) {
        Word ce;
        CompactMealy target = ExampleCoffeeMachine.constructMachine();
        Alphabet alphabet = target.getInputAlphabet();
        MealySimulatorSUL sul = new MealySimulatorSUL((MealyMachine)target);
        LearningAlgorithm learner = (LearningAlgorithm)builder.apply((Alphabet<ExampleCoffeeMachine.Input>)alphabet, (SUL<ExampleCoffeeMachine.Input, String>)sul);
        learner.startLearning();
        MealyMachine hyp = (MealyMachine)learner.getHypothesisModel();
        while ((ce = Automata.findSeparatingWord((UniversalDeterministicAutomaton)target, (UniversalDeterministicAutomaton)hyp, (Collection)alphabet)) != null) {
            DefaultQuery q = new DefaultQuery(ce, (Object)((Word)target.computeOutput((Iterable)ce)));
            while (learner.refineHypothesis(q)) {
            }
            hyp = (MealyMachine)learner.getHypothesisModel();
        }
        return (L)learner;
    }
}

