/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.testsupport;

import de.learnlib.Resumable;
import de.learnlib.algorithm.LearningAlgorithm;
import de.learnlib.query.DefaultQuery;
import de.learnlib.testsupport.ResumeUtils;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.automaton.UniversalDeterministicAutomaton;
import net.automatalib.automaton.concept.Output;
import net.automatalib.util.automaton.Automata;
import net.automatalib.word.Word;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public abstract class AbstractResumableLearnerTest<L extends Resumable<T> & LearningAlgorithm<M, I, D>, M extends UniversalDeterministicAutomaton<?, I, ?, ?, ?> & Output<I, D>, OR, I, D, T> {
    protected static final int RANDOM_SEED = 42;
    private M target;
    private L learner;
    private Alphabet<I> inputAlphabet;
    private int rounds;

    @BeforeClass
    public void setup() {
        this.inputAlphabet = this.getInitialAlphabet();
        this.target = this.getTarget(this.inputAlphabet);
        OR oracle = this.getOracle(this.target);
        this.learner = this.getLearner(oracle, this.inputAlphabet);
        this.rounds = this.getRounds();
    }

    protected abstract Alphabet<I> getInitialAlphabet();

    protected abstract M getTarget(Alphabet<I> var1);

    protected abstract OR getOracle(M var1);

    protected abstract L getLearner(OR var1, Alphabet<I> var2);

    protected abstract int getRounds();

    @Test
    public void testSuspendAndResumeLearner() {
        UniversalDeterministicAutomaton hyp;
        Word ce;
        UniversalDeterministicAutomaton hyp2;
        Word ce2;
        ((LearningAlgorithm)this.learner).startLearning();
        int roundsPre = 0;
        int roundsPost = 0;
        byte[] data = null;
        while ((ce2 = Automata.findSeparatingWord(this.target, (UniversalDeterministicAutomaton)(hyp2 = (UniversalDeterministicAutomaton)((LearningAlgorithm)this.learner).getHypothesisModel()), this.inputAlphabet)) != null) {
            ((LearningAlgorithm)this.learner).refineHypothesis(new DefaultQuery(Word.epsilon(), ce2, ((Output)this.target).computeOutput((Iterable)ce2)));
            if (++roundsPre != this.rounds) continue;
            Object state = this.learner.suspend();
            Assert.assertNotNull((Object)state);
            data = ResumeUtils.toBytes(state);
        }
        Assert.assertNotNull(data);
        L learner2 = this.getLearner(this.getOracle(this.target), this.inputAlphabet);
        learner2.resume(ResumeUtils.fromBytes(data));
        while ((ce = Automata.findSeparatingWord(this.target, (UniversalDeterministicAutomaton)(hyp = (UniversalDeterministicAutomaton)((LearningAlgorithm)learner2).getHypothesisModel()), this.inputAlphabet)) != null) {
            ((LearningAlgorithm)learner2).refineHypothesis(new DefaultQuery(Word.epsilon(), ce, ((Output)this.target).computeOutput((Iterable)ce)));
            ++roundsPost;
        }
        boolean modelsAreEquivalent = Automata.testEquivalence((UniversalDeterministicAutomaton)((UniversalDeterministicAutomaton)((LearningAlgorithm)this.learner).getHypothesisModel()), (UniversalDeterministicAutomaton)((UniversalDeterministicAutomaton)((LearningAlgorithm)learner2).getHypothesisModel()), this.inputAlphabet);
        Assert.assertTrue((boolean)modelsAreEquivalent);
        Assert.assertEquals((int)(roundsPre - roundsPost), (int)this.rounds);
    }
}

