/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.testsupport;

import de.learnlib.algorithm.LearningAlgorithm;
import de.learnlib.query.DefaultQuery;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.alphabet.SupportsGrowingAlphabet;
import net.automatalib.alphabet.impl.Alphabets;
import net.automatalib.alphabet.impl.GrowingMapAlphabet;
import net.automatalib.automaton.UniversalDeterministicAutomaton;
import net.automatalib.automaton.concept.Output;
import net.automatalib.exception.GrowingAlphabetNotSupportedException;
import net.automatalib.util.automaton.Automata;
import net.automatalib.word.Word;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public abstract class AbstractGrowingAlphabetTest<L extends SupportsGrowingAlphabet<I> & LearningAlgorithm<M, I, D>, M extends UniversalDeterministicAutomaton<?, I, ?, ?, ?> & Output<I, D>, OR, I, D> {
    protected static final int RANDOM_SEED = 42;
    protected static final int DEFAULT_AUTOMATON_SIZE = 15;
    private M target;
    private OR oracle;
    private Alphabet<I> initialAlphabet;
    private List<I> alphabetExtensions;

    @BeforeClass
    public void setup() {
        this.initialAlphabet = this.getInitialAlphabet();
        this.alphabetExtensions = new ArrayList<I>(this.getAlphabetExtensions());
        assert (this.alphabetExtensions.size() > 2) : "At least 3 symbols need to be added for proper coverage";
        ArrayList<I> compoundAlphabet = new ArrayList<I>(this.initialAlphabet.size() + this.alphabetExtensions.size());
        compoundAlphabet.addAll((Collection<I>)this.initialAlphabet);
        compoundAlphabet.addAll(this.alphabetExtensions);
        this.target = this.getTarget(Alphabets.fromList(compoundAlphabet));
        this.oracle = this.getOracle(this.target);
    }

    protected abstract Alphabet<I> getInitialAlphabet();

    protected abstract Collection<I> getAlphabetExtensions();

    protected abstract M getTarget(Alphabet<I> var1);

    protected abstract OR getOracle(M var1);

    protected abstract L getLearner(OR var1, Alphabet<I> var2);

    @Test(expectedExceptions={GrowingAlphabetNotSupportedException.class})
    public void testInitialAlphabet() {
        L leaner = this.getLearner(this.oracle, this.initialAlphabet);
        this.testAlphabet(this.initialAlphabet, leaner);
    }

    @Test
    public void testGrowingAlphabet() {
        GrowingMapAlphabet alphabet = new GrowingMapAlphabet(this.initialAlphabet);
        L learner = this.getLearner(this.oracle, (Alphabet<I>)alphabet);
        this.testAlphabet((Alphabet<I>)alphabet, learner);
    }

    private void testAlphabet(Alphabet<I> alphabet, L learner) {
        learner.addAlphabetSymbol(this.alphabetExtensions.get(0));
        ((LearningAlgorithm)learner).startLearning();
        this.performLearnLoopAndCheck(learner, (Collection<? extends I>)alphabet);
        ArrayList<I> currentAlphabet = new ArrayList<I>(alphabet.size() + this.alphabetExtensions.size());
        currentAlphabet.addAll((Collection<I>)alphabet);
        boolean duplicateAdd = false;
        for (I i : this.alphabetExtensions) {
            currentAlphabet.add(i);
            learner.addAlphabetSymbol(i);
            if (duplicateAdd) {
                learner.addAlphabetSymbol(i);
            }
            duplicateAdd = !duplicateAdd;
            UniversalDeterministicAutomaton hyp = (UniversalDeterministicAutomaton)((LearningAlgorithm)learner).getHypothesisModel();
            this.checkCompletenessOfHypothesis(hyp, currentAlphabet);
            this.performLearnLoopAndCheck(learner, currentAlphabet);
        }
    }

    private void performLearnLoopAndCheck(L learner, Collection<? extends I> effectiveAlphabet) {
        UniversalDeterministicAutomaton hyp = (UniversalDeterministicAutomaton)((LearningAlgorithm)learner).getHypothesisModel();
        Word sepWord = Automata.findSeparatingWord(this.target, (UniversalDeterministicAutomaton)hyp, effectiveAlphabet);
        while (sepWord != null) {
            DefaultQuery ce = new DefaultQuery(sepWord, ((Output)this.target).computeOutput((Iterable)sepWord));
            while (((LearningAlgorithm)learner).refineHypothesis(ce)) {
            }
            hyp = (UniversalDeterministicAutomaton)((LearningAlgorithm)learner).getHypothesisModel();
            sepWord = Automata.findSeparatingWord(this.target, (UniversalDeterministicAutomaton)hyp, effectiveAlphabet);
        }
        Assert.assertTrue((boolean)Automata.testEquivalence(this.target, (UniversalDeterministicAutomaton)hyp, effectiveAlphabet));
    }

    private <S, T> void checkCompletenessOfHypothesis(UniversalDeterministicAutomaton<S, I, T, ?, ?> hypothesis, Collection<? extends I> alphabet) {
        for (Object s : hypothesis.getStates()) {
            for (I i : alphabet) {
                Object trans = hypothesis.getTransition(s, i);
                Assert.assertNotNull((Object)trans);
                Assert.assertNotNull((Object)hypothesis.getSuccessor(trans));
            }
        }
    }
}

