/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.testsupport;

import de.learnlib.util.AbstractBFOracle;
import net.automatalib.ts.simple.SimpleDTS;
import net.automatalib.words.Alphabet;
import net.automatalib.words.Word;
import net.automatalib.words.impl.Alphabets;
import org.mockito.MockitoAnnotations;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public abstract class AbstractBFOracleTest<D> {
    public static final Alphabet<Character> ALPHABET = Alphabets.singleton((Object)Character.valueOf('a'));
    public static final double MULTIPLIER = 2.0;
    private AbstractBFOracle<? extends SimpleDTS<?, Character>, Character, D> bfo;

    protected abstract AbstractBFOracle<? extends SimpleDTS<?, Character>, Character, D> createBreadthFirstOracle(double var1);

    @BeforeMethod
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.bfo = this.createBreadthFirstOracle(2.0);
    }

    @Test
    public void testGetMultiplier() {
        Assert.assertEquals((Object)this.bfo.getMultiplier(), (Object)2.0);
    }

    @Test
    public void testNextInput() {
        this.bfo.pre();
        this.bfo.addWord(Word.fromLetter((Object)Character.valueOf('a')));
        this.bfo.addWord(Word.fromLetter((Object)Character.valueOf('b')));
        Assert.assertEquals((Iterable)this.bfo.nextInput(), (Iterable)Word.epsilon());
        Assert.assertEquals((Iterable)this.bfo.nextInput(), (Iterable)Word.fromLetter((Object)Character.valueOf('a')));
        Assert.assertEquals((Iterable)this.bfo.nextInput(), (Iterable)Word.fromLetter((Object)Character.valueOf('b')));
    }

    @Test
    public void testAddWord() {
        this.bfo.pre();
        this.bfo.addWord(Word.epsilon());
        Assert.assertEquals((Iterable)this.bfo.nextInput(), (Iterable)Word.epsilon());
    }

    @Test
    public void testPre() {
        this.bfo.pre();
        this.bfo.addWord(Word.epsilon());
        this.bfo.pre();
        Assert.assertEquals((Iterable)this.bfo.nextInput(), (Iterable)Word.epsilon());
    }
}

