/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.testsupport.example.mealy;

import de.learnlib.testsupport.example.LearningExample;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.automaton.transducer.MealyMachine;
import net.automatalib.automaton.transducer.MutableMealyMachine;
import net.automatalib.automaton.transducer.StateLocalInputMealyMachine;
import net.automatalib.automaton.transducer.impl.CompactMealy;
import net.automatalib.common.util.mapping.Mapping;
import net.automatalib.common.util.mapping.MutableMapping;
import net.automatalib.common.util.random.RandomUtil;
import net.automatalib.util.automaton.minimizer.HopcroftMinimizer;
import net.automatalib.util.automaton.random.RandomAutomata;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ExampleRandomStateLocalInputMealy<I, O>
implements LearningExample.StateLocalInputMealyLearningExample<I, O> {
    private final Alphabet<I> alphabet;
    private final StateLocalInputMealyMachine<?, I, ?, O> referenceAutomaton;
    private final O undefinedOutput;

    @SafeVarargs
    public ExampleRandomStateLocalInputMealy(Random random, Alphabet<I> alphabet, int size, O undefinedOutput, O ... outputs) {
        this(random, alphabet, size, undefinedOutput, ExampleRandomStateLocalInputMealy.validateOutputs(undefinedOutput, outputs));
    }

    private ExampleRandomStateLocalInputMealy(Random random, Alphabet<I> alphabet, int size, O undefinedOutput, List<O> outputs) {
        this.alphabet = alphabet;
        this.undefinedOutput = undefinedOutput;
        CompactMealy source = RandomAutomata.randomMealy((Random)random, (int)size, alphabet, outputs);
        int alphabetSize = alphabet.size();
        Collection oldStates = source.getStates();
        Integer sink = (Integer)source.addState();
        for (Integer s : oldStates) {
            for (int idx : RandomUtil.distinctIntegers((Random)random, (int)random.nextInt(alphabetSize), (int)alphabetSize)) {
                source.setTransition(s.intValue(), idx, sink.intValue(), undefinedOutput);
            }
        }
        for (Object i : alphabet) {
            source.addTransition((Object)sink, i, (Object)sink, undefinedOutput);
        }
        CompactMealy minimized = (CompactMealy)HopcroftMinimizer.minimizeMealyInvasive((MutableMealyMachine)source, alphabet);
        MutableMapping enabledInputs = source.createStaticStateMapping();
        Object object = minimized.iterator();
        while (object.hasNext()) {
            Integer s = (Integer)object.next();
            HashSet<I> stateInputs = new HashSet<I>(alphabet);
            for (Object i : alphabet) {
                if (!Objects.equals(undefinedOutput, minimized.getOutput((Object)s, i))) continue;
                stateInputs.remove(i);
            }
            enabledInputs.put((Object)s, stateInputs);
        }
        this.referenceAutomaton = new MockedSLIMealy(minimized, enabledInputs);
    }

    @SafeVarargs
    public static <I, O> ExampleRandomStateLocalInputMealy<I, O> createExample(Random random, Alphabet<I> alphabet, int size, O undefinedOutput, O ... outputs) {
        return new ExampleRandomStateLocalInputMealy<I, O>(random, alphabet, size, undefinedOutput, outputs);
    }

    @Override
    public StateLocalInputMealyMachine<?, I, ?, O> getReferenceAutomaton() {
        return this.referenceAutomaton;
    }

    @Override
    public Alphabet<I> getAlphabet() {
        return this.alphabet;
    }

    @Override
    public O getUndefinedOutput() {
        return this.undefinedOutput;
    }

    @SafeVarargs
    private static <O> List<O> validateOutputs(O undefinedOutput, O ... outputs) {
        List<O> result = Arrays.asList(outputs);
        if (result.contains(undefinedOutput)) {
            throw new IllegalArgumentException("The special undefined input should not be contained in regular outputs");
        }
        return result;
    }

    private static class MockedSLIMealy<S, I, T, O>
    implements StateLocalInputMealyMachine<S, I, T, O> {
        private final MealyMachine<S, I, T, O> delegate;
        private final Mapping<S, Collection<I>> localInputs;

        MockedSLIMealy(MealyMachine<S, I, T, O> delegate, Mapping<S, Collection<I>> localInputs) {
            this.delegate = delegate;
            this.localInputs = localInputs;
        }

        public Collection<I> getLocalInputs(S state) {
            Collection collection = (Collection)this.localInputs.get(state);
            return collection == null ? Collections.emptyList() : collection;
        }

        public Collection<S> getStates() {
            return this.delegate.getStates();
        }

        public O getTransitionOutput(T transition) {
            return (O)this.delegate.getTransitionOutput(transition);
        }

        public @Nullable T getTransition(S state, I input) {
            return (T)this.delegate.getTransition(state, input);
        }

        public S getSuccessor(T transition) {
            return (S)this.delegate.getSuccessor(transition);
        }

        public @Nullable S getInitialState() {
            return (S)this.delegate.getInitialState();
        }
    }
}

