/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.testsupport.example.mealy;

import de.learnlib.testsupport.example.DefaultLearningExample;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.alphabet.impl.Alphabets;
import net.automatalib.automaton.transducer.MutableMealyMachine;
import net.automatalib.automaton.transducer.impl.CompactMealy;

public class ExampleGrid
extends DefaultLearningExample.DefaultMealyLearningExample<Character, Integer> {
    public ExampleGrid(int xsize, int ysize) {
        super(ExampleGrid.constructMachine(xsize, ysize));
    }

    public static CompactMealy<Character, Integer> constructMachine(int xsize, int ysize) {
        return ExampleGrid.constructMachine(new CompactMealy(ExampleGrid.createInputAlphabet()), xsize, ysize);
    }

    public static <S, A extends MutableMealyMachine<S, Character, ?, Integer>> A constructMachine(A fm, int xsize, int ysize) {
        Object[][] stategrid = new Object[xsize][ysize];
        for (int x = 0; x < xsize; ++x) {
            for (int y = 0; y < ysize; ++y) {
                stategrid[x][y] = x == 0 && y == 0 ? fm.addInitialState() : fm.addState();
            }
        }
        int output = 0;
        for (int x = 0; x < xsize; ++x) {
            for (int y = 0; y < ysize; ++y) {
                int succX = x < xsize - 1 ? x + 1 : x;
                int succY = y < ysize - 1 ? y + 1 : y;
                fm.addTransition(stategrid[x][y], (Object)Character.valueOf('x'), stategrid[succX][y], (Object)output++);
                fm.addTransition(stategrid[x][y], (Object)Character.valueOf('y'), stategrid[x][succY], (Object)output++);
            }
        }
        return fm;
    }

    public static Alphabet<Character> createInputAlphabet() {
        return Alphabets.characters((char)'x', (char)'y');
    }

    public static ExampleGrid createExample(int xsize, int ysize) {
        return new ExampleGrid(xsize, ysize);
    }
}

