/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.testsupport.example.dfa;

import de.learnlib.testsupport.example.DefaultLearningExample;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.alphabet.impl.Alphabets;
import net.automatalib.automaton.fsa.DFA;
import net.automatalib.automaton.fsa.impl.CompactDFA;

public class ExampleKeylock
extends DefaultLearningExample.DefaultDFALearningExample<Integer> {
    private final boolean cyclical;

    public ExampleKeylock(int size, boolean cyclical, int additionalSymbols) {
        super(ExampleKeylock.createDFA(size, cyclical, additionalSymbols));
        this.cyclical = cyclical;
    }

    public static CompactDFA<Integer> createDFA(int size, boolean cyclical, int additionalSymbols) {
        int sym;
        if (size < 2) {
            throw new IllegalArgumentException("Minimum keylock DFA size is 2");
        }
        Alphabet alphabet = Alphabets.integers((int)0, (int)additionalSymbols);
        CompactDFA result = new CompactDFA(alphabet, size);
        int init = result.addIntInitialState((Object)false);
        for (int sym2 = 1; sym2 <= additionalSymbols; ++sym2) {
            result.setTransition(init, sym2, init);
        }
        int prev = init;
        for (int i = 2; i < size; ++i) {
            int curr = result.addIntState((Object)false);
            for (int sym3 = 1; sym3 <= additionalSymbols; ++sym3) {
                result.setTransition(curr, sym3, curr);
            }
            result.setTransition(prev, 0, curr);
            prev = curr;
        }
        int end = result.addIntState((Object)true);
        result.setTransition(prev, 0, end);
        if (cyclical) {
            result.setTransition(end, 0, init);
        }
        int n = sym = cyclical ? 1 : 0;
        while (sym <= additionalSymbols) {
            result.setTransition(end, sym, end);
            ++sym;
        }
        return result;
    }

    public static ExampleKeylock createExample(int size, boolean cyclical) {
        return ExampleKeylock.createExample(size, cyclical, 0);
    }

    public static ExampleKeylock createExample(int size, boolean cyclical, int additionalSymbols) {
        return new ExampleKeylock(size, cyclical, additionalSymbols);
    }

    public String toString() {
        return "Keylock[size=" + ((DFA)((DefaultLearningExample)this).getReferenceAutomaton()).size() + ",alphabetSize=" + this.getAlphabet().size() + ",cyclical=" + this.cyclical + "]";
    }
}

