/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.testsupport.example.dfa;

import de.learnlib.logging.Category;
import de.learnlib.testsupport.example.DefaultLearningExample;
import de.learnlib.testsupport.example.LearningExample;
import java.io.IOException;
import java.io.InputStream;
import net.automatalib.automaton.fsa.impl.CompactDFA;
import net.automatalib.common.util.IOUtil;
import net.automatalib.serialization.learnlibv2.LearnLibV2Serialization;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DFABenchmarks {
    private static final Logger LOGGER = LoggerFactory.getLogger(DFABenchmarks.class);

    private DFABenchmarks() {
    }

    public static  @Nullable LearningExample.DFALearningExample<Integer> loadLearnLibV2Benchmark(String name) {
        String resourceName = "/automata/learnlibv2/" + name + ".dfa.gz";
        InputStream resourceStream = DFABenchmarks.class.getResourceAsStream(resourceName);
        if (resourceStream == null) {
            LOGGER.info(Category.SYSTEM, "Couldn't find resource '{}'", (Object)resourceName);
        } else {
            DefaultLearningExample.DefaultDFALearningExample<Integer> defaultDFALearningExample;
            block10: {
                InputStream is = IOUtil.asUncompressedBufferedInputStream((InputStream)resourceStream);
                try {
                    CompactDFA dfa = LearnLibV2Serialization.getInstance().readGenericDFA(is);
                    defaultDFALearningExample = new DefaultLearningExample.DefaultDFALearningExample<Integer>(dfa);
                    if (is == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException ex) {
                        LOGGER.error(Category.SYSTEM, "Could not load benchmark", (Throwable)ex);
                    }
                }
                is.close();
            }
            return defaultDFALearningExample;
        }
        return null;
    }

    public static LearningExample.DFALearningExample<Integer> loadPots2() {
        return DFABenchmarks.load("pots2");
    }

    public static LearningExample.DFALearningExample<Integer> loadPots3() {
        return DFABenchmarks.load("pots3");
    }

    public static LearningExample.DFALearningExample<Integer> loadPeterson2() {
        return DFABenchmarks.load("peterson2");
    }

    public static LearningExample.DFALearningExample<Integer> loadPeterson3() {
        return DFABenchmarks.load("peterson3");
    }

    private static LearningExample.DFALearningExample<Integer> load(String id) {
        LearningExample.DFALearningExample<Integer> benchmark = DFABenchmarks.loadLearnLibV2Benchmark(id);
        if (benchmark == null) {
            throw new IllegalStateException("Couldn't find '" + id + "'. Are the correct JARs loaded?");
        }
        return benchmark;
    }
}

