/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.testsupport.example;

import de.learnlib.testsupport.example.LearningExample;
import de.learnlib.testsupport.example.dfa.ExampleAngluin;
import de.learnlib.testsupport.example.dfa.ExampleKeylock;
import de.learnlib.testsupport.example.dfa.ExamplePaulAndMary;
import de.learnlib.testsupport.example.dfa.ExampleTinyDFA;
import de.learnlib.testsupport.example.mealy.ExampleCoffeeMachine;
import de.learnlib.testsupport.example.mealy.ExampleGrid;
import de.learnlib.testsupport.example.mealy.ExampleRandomMealy;
import de.learnlib.testsupport.example.mealy.ExampleRandomStateLocalInputMealy;
import de.learnlib.testsupport.example.mealy.ExampleShahbazGroz;
import de.learnlib.testsupport.example.mealy.ExampleStack;
import de.learnlib.testsupport.example.mealy.ExampleTinyMealy;
import de.learnlib.testsupport.example.moore.ExampleRandomMoore;
import de.learnlib.testsupport.example.sba.ExampleRandomSBA;
import de.learnlib.testsupport.example.spa.ExampleRandomSPA;
import de.learnlib.testsupport.example.spmm.ExamplePalindrome;
import de.learnlib.testsupport.example.spmm.ExampleRandomSPMM;
import de.learnlib.testsupport.example.sst.ExampleRandomSST;
import de.learnlib.testsupport.example.vpa.ExampleRandomOneSEVPA;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.alphabet.ProceduralInputAlphabet;
import net.automatalib.alphabet.ProceduralOutputAlphabet;
import net.automatalib.alphabet.VPAlphabet;
import net.automatalib.alphabet.impl.Alphabets;
import net.automatalib.alphabet.impl.DefaultProceduralInputAlphabet;
import net.automatalib.alphabet.impl.DefaultProceduralOutputAlphabet;
import net.automatalib.alphabet.impl.DefaultVPAlphabet;
import net.automatalib.word.Word;

public final class LearningExamples {
    private static final Alphabet<Character> RANDOM_ALPHABET = Alphabets.characters((char)'a', (char)'c');
    private static final ProceduralInputAlphabet<Character> PROCEDURAL_INPUT_ALPHABET = new DefaultProceduralInputAlphabet(Alphabets.characters((char)'A', (char)'F'), Alphabets.characters((char)'a', (char)'f'), (Object)Character.valueOf('R'));
    private static final ProceduralOutputAlphabet<Character> PROCEDURAL_OUTPUT_ALPHABET = new DefaultProceduralOutputAlphabet(Alphabets.characters((char)'u', (char)'z'), (Object)Character.valueOf('\u2717'));
    private static final VPAlphabet<Character> VP_ALPHABET = new DefaultVPAlphabet(Alphabets.characters((char)'a', (char)'f'), Alphabets.characters((char)'1', (char)'3'), Alphabets.characters((char)'7', (char)'9'));
    private static final double ACCEPTANCE_PROB = 0.3;
    private static final double RETURN_PROB = 0.3;
    private static final int RANDOM_SIZE = 100;
    private static final int GRID_XSIZE = 5;
    private static final int GRID_YSIZE = 5;
    private static final String[] RANDOM_MEALY_OUTPUTS = new String[]{"o1", "o2", "o3"};
    private static final Collection<Word<Character>> RANDOM_SST_PROPS = Arrays.asList(Word.fromString((String)"ab"), Word.fromString((String)"bc"), Word.fromString((String)"ca"));
    private static final String UNDEFINED_MEALY_OUTPUT = "undefined";
    private static final int KEYLOCK_SIZE = 100;
    private static final int PROCEDURE_SIZE = 10;
    private static final long RANDOM_SEED = 1337L;

    private LearningExamples() {
    }

    public static List<LearningExample.DFALearningExample<?>> createDFAExamples() {
        return Arrays.asList(ExampleAngluin.createExample(), ExamplePaulAndMary.createExample(), ExampleKeylock.createExample(100, false), ExampleKeylock.createExample(100, true), ExampleTinyDFA.createExample());
    }

    public static List<LearningExample.MealyLearningExample<?, ?>> createMealyExamples() {
        return Arrays.asList(ExampleCoffeeMachine.createExample(), ExampleGrid.createExample(5, 5), ExampleShahbazGroz.createExample(), ExampleStack.createExample(), ExampleRandomMealy.createExample(new Random(1337L), RANDOM_ALPHABET, 100, RANDOM_MEALY_OUTPUTS), ExampleTinyMealy.createExample());
    }

    public static List<LearningExample.MooreLearningExample<?, ?>> createMooreExamples() {
        return Collections.singletonList(ExampleRandomMoore.createExample(new Random(1337L), RANDOM_ALPHABET, 100, RANDOM_MEALY_OUTPUTS));
    }

    public static List<LearningExample.StateLocalInputMealyLearningExample<?, ?>> createSLIMealyExamples() {
        return Collections.singletonList(ExampleRandomStateLocalInputMealy.createExample(new Random(1337L), RANDOM_ALPHABET, 100, UNDEFINED_MEALY_OUTPUT, RANDOM_MEALY_OUTPUTS));
    }

    public static List<LearningExample.SSTLearningExample<?, ?>> createSSTExamples() {
        return Collections.singletonList(ExampleRandomSST.createExample(new Random(1337L), RANDOM_ALPHABET, 100, RANDOM_SST_PROPS, RANDOM_SST_PROPS));
    }

    public static List<LearningExample.SPALearningExample<?>> createSPAExamples() {
        return Arrays.asList(de.learnlib.testsupport.example.spa.ExamplePalindrome.createExample(), ExampleRandomSPA.createExample(new Random(1337L), PROCEDURAL_INPUT_ALPHABET, 10));
    }

    public static List<LearningExample.SBALearningExample<?>> createSBAExamples() {
        return Arrays.asList(de.learnlib.testsupport.example.sba.ExamplePalindrome.createExample(), ExampleRandomSBA.createExample(new Random(1337L), PROCEDURAL_INPUT_ALPHABET, 10));
    }

    public static List<LearningExample.SPMMLearningExample<?, ?>> createSPMMExamples() {
        return Arrays.asList(ExamplePalindrome.createExample(), ExampleRandomSPMM.createExample(new Random(1337L), PROCEDURAL_INPUT_ALPHABET, PROCEDURAL_OUTPUT_ALPHABET, 10));
    }

    public static List<LearningExample.OneSEVPALearningExample<?>> createOneSEVPAExamples() {
        return Collections.singletonList(ExampleRandomOneSEVPA.createExample(new Random(1337L), VP_ALPHABET, 100, 0.3, 0.3));
    }
}

