/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.examples.mealy;

import de.learnlib.examples.LearningExample;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Random;
import net.automatalib.automata.MutableDeterministic;
import net.automatalib.automata.transducers.MealyMachine;
import net.automatalib.automata.transducers.StateLocalInputMealyMachine;
import net.automatalib.automata.transducers.impl.compact.CompactMealy;
import net.automatalib.commons.util.mappings.Mapping;
import net.automatalib.commons.util.mappings.MutableMapping;
import net.automatalib.commons.util.random.RandomUtil;
import net.automatalib.util.automata.Automata;
import net.automatalib.util.automata.random.RandomAutomata;
import net.automatalib.words.Alphabet;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ExampleRandomStateLocalInputMealy<I, O>
implements LearningExample.StateLocalInputMealyLearningExample<I, O> {
    private final Alphabet<I> alphabet;
    private final StateLocalInputMealyMachine<?, I, ?, O> referenceAutomaton;
    private final O undefinedOutput;

    @SafeVarargs
    public ExampleRandomStateLocalInputMealy(Alphabet<I> alphabet, int size, O undefinedOutput, O ... outputs) {
        this(new Random(), alphabet, size, undefinedOutput, outputs);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SafeVarargs
    public ExampleRandomStateLocalInputMealy(Random random, Alphabet<I> alphabet, int size, O undefinedOutput, O ... outputs) {
        if (Arrays.asList(outputs).contains(undefinedOutput)) {
            throw new IllegalArgumentException("The special undefined input should not be contained in regular outputs");
        }
        this.alphabet = alphabet;
        this.undefinedOutput = undefinedOutput;
        CompactMealy source = RandomAutomata.randomMealy((Random)random, (int)size, alphabet, Arrays.asList(outputs));
        int alphabetSize = alphabet.size();
        Collection oldStates = source.getStates();
        Integer sink = (Integer)source.addState();
        for (Integer s : oldStates) {
            for (int idx : RandomUtil.distinctIntegers((int)random.nextInt(alphabetSize), (int)alphabetSize, (Random)random)) {
                source.setTransition(s.intValue(), idx, sink.intValue(), undefinedOutput);
            }
        }
        for (Object i : alphabet) {
            source.addTransition((Object)sink, i, (Object)sink, undefinedOutput);
        }
        CompactMealy minimized = (CompactMealy)Automata.invasiveMinimize((MutableDeterministic)source, alphabet);
        @Nullable MutableMapping enabledInputs = source.createStaticStateMapping();
        Object object = minimized.iterator();
        while (object.hasNext()) {
            Integer s = (Integer)object.next();
            HashSet<I> stateInputs = new HashSet<I>(alphabet);
            for (Object i : alphabet) {
                if (!Objects.equals(undefinedOutput, minimized.getOutput((Object)s, i))) continue;
                stateInputs.remove(i);
            }
            enabledInputs.put((Object)s, stateInputs);
        }
        this.referenceAutomaton = new MockedSLIMealy(minimized, enabledInputs);
    }

    @SafeVarargs
    public static <I, O> ExampleRandomStateLocalInputMealy<I, O> createExample(Random random, Alphabet<I> alphabet, int size, O undefinedOutput, O ... outputs) {
        return new ExampleRandomStateLocalInputMealy<I, O>(random, alphabet, size, undefinedOutput, outputs);
    }

    @Override
    public StateLocalInputMealyMachine<?, I, ?, O> getReferenceAutomaton() {
        return this.referenceAutomaton;
    }

    @Override
    public Alphabet<I> getAlphabet() {
        return this.alphabet;
    }

    @Override
    public O getUndefinedOutput() {
        return this.undefinedOutput;
    }

    private static class MockedSLIMealy<S, I, T, O>
    implements StateLocalInputMealyMachine<S, I, T, O> {
        private final MealyMachine<S, I, T, O> delegate;
        private final Mapping<S, @Nullable Collection<I>> localInputs;

        MockedSLIMealy(MealyMachine<S, I, T, O> delegate, Mapping<S, @Nullable Collection<I>> localInputs) {
            this.delegate = delegate;
            this.localInputs = localInputs;
        }

        public Collection<I> getLocalInputs(S state) {
            Collection collection = (Collection)this.localInputs.get(state);
            return collection == null ? Collections.emptyList() : collection;
        }

        public Collection<S> getStates() {
            return this.delegate.getStates();
        }

        public O getTransitionOutput(T transition) {
            return (O)this.delegate.getTransitionOutput(transition);
        }

        public @Nullable T getTransition(S state, I input) {
            return (T)this.delegate.getTransition(state, input);
        }

        public S getSuccessor(T transition) {
            return (S)this.delegate.getSuccessor(transition);
        }

        public @Nullable S getInitialState() {
            return (S)this.delegate.getInitialState();
        }
    }
}

