/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.examples.dfa;

import de.learnlib.examples.DefaultLearningExample;
import de.learnlib.examples.LearningExample;
import java.io.IOException;
import java.io.InputStream;
import net.automatalib.automata.fsa.impl.compact.CompactDFA;
import net.automatalib.serialization.learnlibv2.LearnLibV2Serialization;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DFABenchmarks {
    private static final Logger LOGGER = LoggerFactory.getLogger(DFABenchmarks.class);

    private DFABenchmarks() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static @Nullable LearningExample.DFALearningExample<Integer> loadLearnLibV2Benchmark(String name) {
        String resourceName = "/automata/learnlibv2/" + name + ".dfa.gz";
        InputStream resourceStream = DFABenchmarks.class.getResourceAsStream(resourceName);
        if (resourceStream == null) {
            LOGGER.info("Couldn't find resource '{}'", (Object)resourceName);
            return null;
        }
        try (InputStream is = resourceStream;){
            CompactDFA dfa = LearnLibV2Serialization.getInstance().readGenericDFA(is);
            DefaultLearningExample.DefaultDFALearningExample<Integer> defaultDFALearningExample = new DefaultLearningExample.DefaultDFALearningExample<Integer>(dfa);
            return defaultDFALearningExample;
        }
        catch (IOException ex) {
            LOGGER.error("Could not load benchmark", (Throwable)ex);
        }
        return null;
    }

    public static LearningExample.DFALearningExample<Integer> loadPots2() {
        return DFABenchmarks.load("pots2");
    }

    public static LearningExample.DFALearningExample<Integer> loadPots3() {
        return DFABenchmarks.load("pots3");
    }

    public static LearningExample.DFALearningExample<Integer> loadPeterson2() {
        return DFABenchmarks.load("peterson2");
    }

    public static LearningExample.DFALearningExample<Integer> loadPeterson3() {
        return DFABenchmarks.load("peterson3");
    }

    private static LearningExample.DFALearningExample<Integer> load(String id) {
        LearningExample.DFALearningExample<Integer> benchmark = DFABenchmarks.loadLearnLibV2Benchmark(id);
        if (benchmark == null) {
            throw new IllegalStateException("Couldn't find '" + id + "'. Are the correct JARs loaded?");
        }
        return benchmark;
    }
}

