/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.examples.mealy;

import de.learnlib.examples.LearningExample;
import java.util.Arrays;
import java.util.Random;
import net.automatalib.automata.MutableDeterministic;
import net.automatalib.automata.transducers.impl.compact.CompactMealy;
import net.automatalib.commons.util.random.RandomUtil;
import net.automatalib.util.automata.random.RandomAutomata;
import net.automatalib.words.Alphabet;

public class ExampleRandomStateLocalInputMealy<I, O>
implements LearningExample.StateLocalInputMealyLearningExample<I, O> {
    private final CompactMealy<I, O> automaton;

    @SafeVarargs
    public ExampleRandomStateLocalInputMealy(Alphabet<I> alphabet, int size, O ... outputs) {
        this(new Random(), alphabet, size, outputs);
    }

    @SafeVarargs
    public ExampleRandomStateLocalInputMealy(Random random, Alphabet<I> alphabet, int size, O ... outputs) {
        this.automaton = (CompactMealy)RandomAutomata.randomDeterministic((Random)random, (int)size, alphabet, null, Arrays.asList(outputs), (MutableDeterministic)new CompactMealy(alphabet));
        int alphabetSize = alphabet.size();
        for (int i = 0; i < size; ++i) {
            for (int idx : RandomUtil.distinctIntegers((int)random.nextInt(alphabetSize), (int)alphabetSize, (Random)random)) {
                this.automaton.removeAllTransitions((Object)i, alphabet.getSymbol(idx));
            }
        }
    }

    @SafeVarargs
    public static <I, O> ExampleRandomStateLocalInputMealy<I, O> createExample(Random random, Alphabet<I> alphabet, int size, O ... outputs) {
        return new ExampleRandomStateLocalInputMealy<I, O>(random, alphabet, size, outputs);
    }

    @Override
    public CompactMealy<I, O> getReferenceAutomaton() {
        return this.automaton;
    }

    @Override
    public Alphabet<I> getAlphabet() {
        return this.automaton.getInputAlphabet();
    }
}

