/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.examples.dfa;

import de.learnlib.examples.DefaultLearningExample;
import de.learnlib.examples.LearningExample;
import java.io.IOException;
import java.io.InputStream;
import net.automatalib.automata.fsa.impl.compact.CompactDFA;
import net.automatalib.serialization.learnlibv2.LearnLibV2Serialization;

public class DFABenchmarks {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static LearningExample.DFALearningExample<Integer> loadLearnLibV2Benchmark(String name) {
        String resourceName = "/automata/learnlibv2/" + name + ".dfa";
        DFABenchmarks.class.getResource(resourceName);
        if (DFABenchmarks.class.getResource(resourceName) == null && DFABenchmarks.class.getResource(resourceName = resourceName + ".gz") == null) {
            return null;
        }
        try (InputStream is = DFABenchmarks.class.getResourceAsStream(resourceName);){
            CompactDFA dfa = LearnLibV2Serialization.getInstance().readGenericDFA(is);
            DefaultLearningExample.DefaultDFALearningExample<Integer> defaultDFALearningExample = new DefaultLearningExample.DefaultDFALearningExample<Integer>(dfa);
            return defaultDFALearningExample;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static LearningExample.DFALearningExample<Integer> loadPots2() {
        return DFABenchmarks.loadLearnLibV2Benchmark("pots2");
    }

    public static LearningExample.DFALearningExample<Integer> loadPots3() {
        return DFABenchmarks.loadLearnLibV2Benchmark("pots3");
    }

    public static LearningExample.DFALearningExample<Integer> loadPeterson2() {
        return DFABenchmarks.loadLearnLibV2Benchmark("peterson2");
    }

    public static LearningExample.DFALearningExample<Integer> loadPeterson3() {
        return DFABenchmarks.loadLearnLibV2Benchmark("peterson3");
    }
}

